/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.client;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.AnalyticsEvent;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.InternalEvent;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.Session;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.client.DefaultSessionClient;

public abstract class SessionClientState {
    protected final DefaultSessionClient client;

    public SessionClientState(DefaultSessionClient client) {
        this.client = client;
    }

    public abstract void resume();

    public abstract void pause();

    public abstract void start();

    public abstract void stop();

    protected void executeStart() {
        this.client.session = Session.newInstance(this.client.context);
        this.client.eventClient.setSessionId(this.client.session.getSessionID());
        this.client.eventClient.setSessionStartTime(this.client.session.getStartTime());
        DefaultSessionClient.logger.devv("Firing Session Event: _session.start");
        AnalyticsEvent e = this.client.eventClient.createEvent("_session.start");
        this.client.eventClient.recordEvent(e);
        this.client.changeState(DefaultSessionClient.SessionState.ACTIVE);
    }

    protected void executeStop() {
        if (!this.client.session.isPaused()) {
            this.client.session.pause();
        }
        DefaultSessionClient.logger.devv("Firing Session Event: _session.stop");
        Long stopTime = this.client.session.getStopTime() == null ? 0L : this.client.session.getStopTime();
        InternalEvent e = this.client.eventClient.createInternalEvent("_session.stop", this.client.session.getStartTime(), stopTime, this.client.session.getSessionDuration());
        this.client.eventClient.recordEvent(e);
        this.client.eventClient.removeGlobalAttribute("_session.id");
        this.client.session = null;
        this.client.changeState(DefaultSessionClient.SessionState.INACTIVE);
    }

    protected void executePause() {
        this.client.session.pause();
        DefaultSessionClient.logger.i("Session Paused: " + this.client.session.getSessionID());
        DefaultSessionClient.logger.devi("Session Paused.");
        DefaultSessionClient.logger.devv("Firing Session Event: _session.pause");
        InternalEvent e = this.client.eventClient.createInternalEvent("_session.pause", this.client.session.getStartTime(), null, this.client.session.getSessionDuration());
        this.client.eventClient.recordEvent(e);
        this.client.sessionStore.storeSession(this.client.session);
        this.client.changeState(DefaultSessionClient.SessionState.PAUSED);
    }

    protected void executeResume() {
        this.client.session.resume();
        DefaultSessionClient.logger.devv("Firing Session Event: _session.resume");
        AnalyticsEvent e = this.client.eventClient.createEvent("_session.resume");
        this.client.eventClient.recordEvent(e);
        DefaultSessionClient.logger.i("Session Resumed: " + this.client.session.getSessionID());
        DefaultSessionClient.logger.devi("Session Resumed.");
        this.client.changeState(DefaultSessionClient.SessionState.ACTIVE);
    }
}

