/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.monetization;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.EventClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.log.Logger;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.monetization.MonetizationEventBuilder;

public class AmazonMonetizationEventBuilder
extends MonetizationEventBuilder {
    private static Logger logger = Logger.getLogger(AmazonMonetizationEventBuilder.class);

    public static AmazonMonetizationEventBuilder create(EventClient eventClient) {
        return new AmazonMonetizationEventBuilder(eventClient);
    }

    public AmazonMonetizationEventBuilder withProductId(String productId) {
        this.setProductId(productId);
        return this;
    }

    public AmazonMonetizationEventBuilder withFormattedItemPrice(String formattedItemPrice) {
        this.setFormattedItemPrice(formattedItemPrice);
        return this;
    }

    public AmazonMonetizationEventBuilder withQuantity(Double quantity) {
        this.setQuantity(quantity);
        return this;
    }

    protected AmazonMonetizationEventBuilder(EventClient eventClient) {
        super(eventClient);
        this.setStore("Amazon");
    }

    protected boolean isValid() {
        if (this.getProductId() == null) {
            logger.devw("Amazon Monetization event is not valid: it is missing the product id");
            return false;
        }
        if (this.getQuantity() == null) {
            logger.devw("Amazon Monetization event is not valid: it is missing the quantity");
            return false;
        }
        if (this.getFormattedItemPrice() == null) {
            logger.devw("Amazon Monetization event is not valid: it is missing the formatted localized price");
            return false;
        }
        return true;
    }
}

