/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.monetization;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.EventClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.log.Logger;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.monetization.MonetizationEventBuilder;

public class GooglePlayMonetizationEventBuilder
extends MonetizationEventBuilder {
    private static Logger logger = Logger.getLogger(GooglePlayMonetizationEventBuilder.class);

    public static GooglePlayMonetizationEventBuilder create(EventClient eventClient) {
        return new GooglePlayMonetizationEventBuilder(eventClient);
    }

    public GooglePlayMonetizationEventBuilder withProductId(String productId) {
        this.setProductId(productId);
        return this;
    }

    public GooglePlayMonetizationEventBuilder withFormattedItemPrice(String formattedItemPrice) {
        this.setFormattedItemPrice(formattedItemPrice);
        return this;
    }

    public GooglePlayMonetizationEventBuilder withQuantity(Double quantity) {
        this.setQuantity(quantity);
        return this;
    }

    public GooglePlayMonetizationEventBuilder withTransactionId(String transactionId) {
        this.setTransactionId(transactionId);
        return this;
    }

    protected GooglePlayMonetizationEventBuilder(EventClient eventClient) {
        super(eventClient);
        this.setStore("Google Play");
    }

    protected boolean isValid() {
        if (this.getProductId() == null) {
            logger.devw("Cannot build Google Monetization event: it is missing the product id");
            return false;
        }
        if (this.getQuantity() == null) {
            logger.devw("Google Monetization event is not valid: it is missing the quantity");
            return false;
        }
        if (this.getFormattedItemPrice() == null) {
            logger.devw("Google Monetization event is not valid: it is missing the formatted localized price");
            return false;
        }
        if (this.getTransactionId() == null) {
            logger.devw("Google Monetization event is not valid: it is missing the transaction id");
            return false;
        }
        return true;
    }
}

