/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.monetization;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.EventClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.log.Logger;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.monetization.MonetizationEventBuilder;

public class VirtualMonetizationEventBuilder
extends MonetizationEventBuilder {
    private static Logger logger = Logger.getLogger(VirtualMonetizationEventBuilder.class);

    public static VirtualMonetizationEventBuilder create(EventClient eventClient) {
        return new VirtualMonetizationEventBuilder(eventClient);
    }

    public VirtualMonetizationEventBuilder withProductId(String productId) {
        this.setProductId(productId);
        return this;
    }

    public VirtualMonetizationEventBuilder withItemPrice(double itemPrice) {
        this.setItemPrice(itemPrice);
        return this;
    }

    public VirtualMonetizationEventBuilder withQuantity(Double quantity) {
        this.setQuantity(quantity);
        return this;
    }

    public VirtualMonetizationEventBuilder withCurrency(String currency) {
        this.setCurrency(currency);
        return this;
    }

    protected VirtualMonetizationEventBuilder(EventClient eventClient) {
        super(eventClient);
        this.setStore("Virtual");
    }

    protected boolean isValid() {
        if (this.getProductId() == null) {
            logger.devw("Virtual Monetization event is not valid: it is missing the product id");
            return false;
        }
        if (this.getQuantity() == null) {
            logger.devw("Virtual Monetization event is not valid: it is missing the quantity");
            return false;
        }
        if (this.getItemPrice() == null) {
            logger.devw("Virtual Monetization event is not valid: it is missing the numerical price");
            return false;
        }
        if (this.getCurrency() == null) {
            logger.devw("Virtual Monetization event is not valid: it is missing the currency");
            return false;
        }
        return true;
    }
}

