/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper;

import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.AttributeTransformer;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeTransformerChain
implements AttributeTransformer {
    private final List<AttributeTransformer> transformers;

    public AttributeTransformerChain(AttributeTransformer ... transformers) {
        this(Arrays.asList(transformers));
    }

    public AttributeTransformerChain(List<AttributeTransformer> transformers) {
        this.transformers = Collections.unmodifiableList(new ArrayList<AttributeTransformer>(transformers));
    }

    public List<AttributeTransformer> getTransformers() {
        return this.transformers;
    }

    @Override
    public Map<String, AttributeValue> transform(AttributeTransformer.Parameters<?> parameters) {
        ProxyParameters proxy = new ProxyParameters(parameters);
        for (int i = 0; i < this.transformers.size(); ++i) {
            proxy.setAttributeValues(this.transformers.get(i).transform(proxy));
        }
        return proxy.getAttributeValues();
    }

    @Override
    public Map<String, AttributeValue> untransform(AttributeTransformer.Parameters<?> parameters) {
        ProxyParameters proxy = new ProxyParameters(parameters);
        for (int i = this.transformers.size() - 1; i >= 0; --i) {
            proxy.setAttributeValues(this.transformers.get(i).untransform(proxy));
        }
        return proxy.getAttributeValues();
    }

    public String toString() {
        return this.transformers.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProxyParameters<T>
    implements AttributeTransformer.Parameters<T> {
        private final AttributeTransformer.Parameters<T> delegate;
        private Map<String, AttributeValue> values;

        public ProxyParameters(AttributeTransformer.Parameters<T> delegate) {
            this.delegate = delegate;
            this.values = delegate.getAttributeValues();
        }

        @Override
        public Map<String, AttributeValue> getAttributeValues() {
            return this.values;
        }

        public void setAttributeValues(Map<String, AttributeValue> values) {
            this.values = Collections.unmodifiableMap(values);
        }

        @Override
        public boolean isPartialUpdate() {
            return this.delegate.isPartialUpdate();
        }

        @Override
        public Class<T> getModelClass() {
            return this.delegate.getModelClass();
        }

        @Override
        public DynamoDBMapperConfig getMapperConfig() {
            return this.delegate.getMapperConfig();
        }

        @Override
        public String getTableName() {
            return this.delegate.getTableName();
        }

        @Override
        public String getHashKeyName() {
            return this.delegate.getHashKeyName();
        }

        @Override
        public String getRangeKeyName() {
            return this.delegate.getRangeKeyName();
        }
    }
}

