/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper;

import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.ArgumentMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.ArgumentUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.ConversionSchema;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBDocument;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMapperFieldModel;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMappingException;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMarshalling;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBNativeBoolean;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBReflector;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.ItemConverter;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.ReflectionUtils;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.S3ClientCache;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.S3Link;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.BooleanSetToNumberSetMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.BooleanToBooleanMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.BooleanToNumberMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.ByteArraySetToBinarySetMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.ByteArrayToBinaryMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.ByteBufferSetToBinarySetMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.ByteBufferToBinaryMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.CalendarSetToStringSetMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.CalendarToStringMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.CustomMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.DateSetToStringSetMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.DateToStringMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.ListToListMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.MapToMapMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.NumberSetToNumberSetMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.NumberToNumberMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.ObjectSetToStringSetMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.ObjectToMapMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.S3LinkToStringMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.StringSetToStringSetMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers.StringToStringMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.BigDecimalSetUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.BigDecimalUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.BigIntegerSetUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.BigIntegerUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.BooleanSetUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.BooleanUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.ByteArraySetUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.ByteArrayUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.ByteBufferSetUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.ByteBufferUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.ByteSetUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.ByteUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.CalendarSetUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.CalendarUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.CustomUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.DateSetUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.DateUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.DoubleSetUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.DoubleUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.FloatSetUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.FloatUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.IntegerSetUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.IntegerUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.ListUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.LongSetUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.LongUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.MapUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.NullableUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.ObjectUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.S3LinkUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.ShortSetUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.ShortUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.StringSetUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.StringUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConversionSchemas {
    private static final Log LOGGER = LogFactory.getLog(ConversionSchemas.class);
    public static final ConversionSchema V1 = new StandardConversionSchema("V1ConversionSchema", new V1MarshallerSet(), new StandardUnmarshallerSet());
    public static final ConversionSchema V2_COMPATIBLE = new StandardConversionSchema("V2CompatibleConversionSchema", new V2CompatibleMarshallerSet(), new StandardUnmarshallerSet());
    public static final ConversionSchema V2 = new StandardConversionSchema("V2ConversionSchema", new V2MarshallerSet(), new StandardUnmarshallerSet());
    static final ConversionSchema DEFAULT = V2_COMPATIBLE;

    private static void addStandardDateMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Date.class, DateToStringMarshaller.instance()));
        list.add(Pair.of(Calendar.class, CalendarToStringMarshaller.instance()));
    }

    private static void addV1BooleanMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Boolean.class, BooleanToNumberMarshaller.instance()));
        list.add(Pair.of(Boolean.TYPE, BooleanToNumberMarshaller.instance()));
    }

    private static void addV2BooleanMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Boolean.class, BooleanToBooleanMarshaller.instance()));
        list.add(Pair.of(Boolean.TYPE, BooleanToBooleanMarshaller.instance()));
    }

    private static void addStandardNumberMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Number.class, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Byte.TYPE, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Short.TYPE, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Integer.TYPE, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Long.TYPE, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Float.TYPE, NumberToNumberMarshaller.instance()));
        list.add(Pair.of(Double.TYPE, NumberToNumberMarshaller.instance()));
    }

    private static void addStandardStringMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(String.class, StringToStringMarshaller.instance()));
    }

    private static void addStandardBinaryMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(ByteBuffer.class, ByteBufferToBinaryMarshaller.instance()));
        list.add(Pair.of(byte[].class, ByteArrayToBinaryMarshaller.instance()));
    }

    private static void addStandardS3LinkMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(S3Link.class, S3LinkToStringMarshaller.instance()));
    }

    private static void addStandardDateSetMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Date.class, DateSetToStringSetMarshaller.instance()));
        list.add(Pair.of(Calendar.class, CalendarSetToStringSetMarshaller.instance()));
    }

    private static void addStandardNumberSetMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Number.class, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Byte.TYPE, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Short.TYPE, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Integer.TYPE, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Long.TYPE, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Float.TYPE, NumberSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Double.TYPE, NumberSetToNumberSetMarshaller.instance()));
    }

    private static void addStandardStringSetMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(String.class, StringSetToStringSetMarshaller.instance()));
    }

    private static void addStandardBinarySetMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(ByteBuffer.class, ByteBufferSetToBinarySetMarshaller.instance()));
        list.add(Pair.of(byte[].class, ByteArraySetToBinarySetMarshaller.instance()));
    }

    private static void addV1BooleanSetMarshallers(List<Pair<ArgumentMarshaller>> list) {
        list.add(Pair.of(Boolean.class, BooleanSetToNumberSetMarshaller.instance()));
        list.add(Pair.of(Boolean.TYPE, BooleanSetToNumberSetMarshaller.instance()));
    }

    private static Class<?> unwrapGenericSetParam(Type setType) {
        if (!(setType instanceof ParameterizedType)) {
            LOGGER.warn((Object)("Set type " + setType + " is not a " + "ParameterizedType, using default marshaler and " + "unmarshaler!"));
            return Object.class;
        }
        ParameterizedType ptype = (ParameterizedType)setType;
        Type[] arguments = ptype.getActualTypeArguments();
        if (arguments.length != 1) {
            LOGGER.warn((Object)("Set type " + setType + " does not have exactly one " + "type argument, using default marshaler and " + "unmarshaler!"));
            return Object.class;
        }
        if (arguments[0].toString().equals("byte[]")) {
            return byte[].class;
        }
        return (Class)arguments[0];
    }

    private static <T> T find(Class<?> needle, List<Pair<T>> haystack) {
        for (Pair<T> pair : haystack) {
            if (!pair.key.isAssignableFrom(needle)) continue;
            return pair.value;
        }
        return null;
    }

    ConversionSchemas() {
        throw new UnsupportedOperationException();
    }

    static class CachingUnmarshallerSet
    implements UnmarshallerSet {
        private final Map<Method, ArgumentUnmarshaller> cache = new HashMap<Method, ArgumentUnmarshaller>();
        private final Map<Type, ArgumentUnmarshaller> memberCache = new HashMap<Type, ArgumentUnmarshaller>();
        private final UnmarshallerSet wrapped;

        public CachingUnmarshallerSet(UnmarshallerSet wrapped) {
            this.wrapped = wrapped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArgumentUnmarshaller getUnmarshaller(Method getter, Method setter) {
            Map<Method, ArgumentUnmarshaller> map = this.cache;
            synchronized (map) {
                ArgumentUnmarshaller unmarshaler = this.cache.get(getter);
                if (unmarshaler != null) {
                    return unmarshaler;
                }
                unmarshaler = this.wrapped.getUnmarshaller(getter, setter);
                this.cache.put(getter, unmarshaler);
                return unmarshaler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArgumentUnmarshaller getMemberUnmarshaller(Type memberType) {
            Map<Type, ArgumentUnmarshaller> map = this.memberCache;
            synchronized (map) {
                ArgumentUnmarshaller unmarshaller = this.memberCache.get(memberType);
                if (unmarshaller != null) {
                    return unmarshaller;
                }
                unmarshaller = this.wrapped.getMemberUnmarshaller(memberType);
                this.memberCache.put(memberType, unmarshaller);
                return unmarshaller;
            }
        }
    }

    static class CachingMarshallerSet
    implements MarshallerSet {
        private final Map<Method, ArgumentMarshaller> cache = new HashMap<Method, ArgumentMarshaller>();
        private final Map<Type, ArgumentMarshaller> memberCache = new HashMap<Type, ArgumentMarshaller>();
        private final MarshallerSet wrapped;

        public CachingMarshallerSet(MarshallerSet wrapped) {
            this.wrapped = wrapped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArgumentMarshaller getMarshaller(Method getter) {
            Map<Method, ArgumentMarshaller> map = this.cache;
            synchronized (map) {
                ArgumentMarshaller marshaler = this.cache.get(getter);
                if (marshaler != null) {
                    return marshaler;
                }
                marshaler = this.wrapped.getMarshaller(getter);
                this.cache.put(getter, marshaler);
                return marshaler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArgumentMarshaller getMemberMarshaller(Type memberType) {
            Map<Type, ArgumentMarshaller> map = this.memberCache;
            synchronized (map) {
                ArgumentMarshaller marshaller = this.memberCache.get(memberType);
                if (marshaller != null) {
                    return marshaller;
                }
                marshaller = this.wrapped.getMemberMarshaller(memberType);
                this.memberCache.put(memberType, marshaller);
                return marshaller;
            }
        }
    }

    static class AnnotationAwareUnmarshallerSet
    implements UnmarshallerSet {
        private final UnmarshallerSet wrapped;

        public AnnotationAwareUnmarshallerSet(UnmarshallerSet wrapped) {
            this.wrapped = wrapped;
        }

        public ArgumentUnmarshaller getUnmarshaller(Method getter, Method setter) {
            DynamoDBMarshalling annotation = ReflectionUtils.getAnnotationFromGetterOrField(getter, DynamoDBMarshalling.class);
            if (annotation != null) {
                return new CustomUnmarshaller(getter.getReturnType(), annotation.marshallerClass());
            }
            return this.wrapped.getUnmarshaller(getter, setter);
        }

        public ArgumentUnmarshaller getMemberUnmarshaller(Type c) {
            return this.wrapped.getMemberUnmarshaller(c);
        }
    }

    static class AnnotationAwareMarshallerSet
    implements MarshallerSet {
        private final MarshallerSet wrapped;

        public AnnotationAwareMarshallerSet(MarshallerSet wrapped) {
            this.wrapped = wrapped;
        }

        public ArgumentMarshaller getMarshaller(Method getter) {
            DynamoDBMarshalling annotation = ReflectionUtils.getAnnotationFromGetterOrField(getter, DynamoDBMarshalling.class);
            if (annotation != null) {
                return new CustomMarshaller(annotation.marshallerClass());
            }
            DynamoDBNativeBoolean boolAnnotation = ReflectionUtils.getAnnotationFromGetterOrField(getter, DynamoDBNativeBoolean.class);
            if (boolAnnotation != null) {
                return BooleanToBooleanMarshaller.instance();
            }
            return this.wrapped.getMarshaller(getter);
        }

        public ArgumentMarshaller getMemberMarshaller(Type memberType) {
            return this.wrapped.getMemberMarshaller(memberType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pair<T> {
        public final Class<?> key;
        public final T value;

        public static Pair<ArgumentMarshaller> of(Class<?> key, ArgumentMarshaller value) {
            return new Pair<ArgumentMarshaller>(key, value);
        }

        public static Pair<ArgumentUnmarshaller> of(Class<?> key, ArgumentUnmarshaller value) {
            return new Pair<ArgumentUnmarshaller>(key, value);
        }

        private Pair(Class<?> key, T value) {
            this.key = key;
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StandardUnmarshallerSet
    implements UnmarshallerSet {
        private final List<Pair<ArgumentUnmarshaller>> unmarshallers;
        private final List<Pair<ArgumentUnmarshaller>> setUnmarshallers;

        public StandardUnmarshallerSet() {
            this(StandardUnmarshallerSet.unmarshallers(), StandardUnmarshallerSet.setUnmarshallers());
        }

        public StandardUnmarshallerSet(List<Pair<ArgumentUnmarshaller>> unmarshallers, List<Pair<ArgumentUnmarshaller>> setUnmarshallers) {
            this.unmarshallers = unmarshallers;
            this.setUnmarshallers = setUnmarshallers;
        }

        private static List<Pair<ArgumentUnmarshaller>> unmarshallers() {
            ArrayList<Pair<ArgumentUnmarshaller>> list = new ArrayList<Pair<ArgumentUnmarshaller>>();
            list.add(Pair.of(Double.TYPE, DoubleUnmarshaller.instance()));
            list.add(Pair.of(Double.class, DoubleUnmarshaller.instance()));
            list.add(Pair.of(BigDecimal.class, BigDecimalUnmarshaller.instance()));
            list.add(Pair.of(BigInteger.class, BigIntegerUnmarshaller.instance()));
            list.add(Pair.of(Integer.TYPE, IntegerUnmarshaller.instance()));
            list.add(Pair.of(Integer.class, IntegerUnmarshaller.instance()));
            list.add(Pair.of(Float.TYPE, FloatUnmarshaller.instance()));
            list.add(Pair.of(Float.class, FloatUnmarshaller.instance()));
            list.add(Pair.of(Byte.TYPE, ByteUnmarshaller.instance()));
            list.add(Pair.of(Byte.class, ByteUnmarshaller.instance()));
            list.add(Pair.of(Long.TYPE, LongUnmarshaller.instance()));
            list.add(Pair.of(Long.class, LongUnmarshaller.instance()));
            list.add(Pair.of(Short.TYPE, ShortUnmarshaller.instance()));
            list.add(Pair.of(Short.class, ShortUnmarshaller.instance()));
            list.add(Pair.of(Boolean.TYPE, BooleanUnmarshaller.instance()));
            list.add(Pair.of(Boolean.class, BooleanUnmarshaller.instance()));
            list.add(Pair.of(Date.class, DateUnmarshaller.instance()));
            list.add(Pair.of(Calendar.class, CalendarUnmarshaller.instance()));
            list.add(Pair.of(ByteBuffer.class, ByteBufferUnmarshaller.instance()));
            list.add(Pair.of(byte[].class, ByteArrayUnmarshaller.instance()));
            list.add(Pair.of(S3Link.class, S3LinkUnmarshaller.instance()));
            list.add(Pair.of(String.class, StringUnmarshaller.instance()));
            list.add(Pair.of(List.class, ListUnmarshaller.instance()));
            list.add(Pair.of(Map.class, MapUnmarshaller.instance()));
            list.add(Pair.of(Object.class, ObjectUnmarshaller.instance()));
            return list;
        }

        private static List<Pair<ArgumentUnmarshaller>> setUnmarshallers() {
            ArrayList<Pair<ArgumentUnmarshaller>> list = new ArrayList<Pair<ArgumentUnmarshaller>>();
            list.add(Pair.of(Double.TYPE, DoubleSetUnmarshaller.instance()));
            list.add(Pair.of(Double.class, DoubleSetUnmarshaller.instance()));
            list.add(Pair.of(BigDecimal.class, BigDecimalSetUnmarshaller.instance()));
            list.add(Pair.of(BigInteger.class, BigIntegerSetUnmarshaller.instance()));
            list.add(Pair.of(Integer.TYPE, IntegerSetUnmarshaller.instance()));
            list.add(Pair.of(Integer.class, IntegerSetUnmarshaller.instance()));
            list.add(Pair.of(Float.TYPE, FloatSetUnmarshaller.instance()));
            list.add(Pair.of(Float.class, FloatSetUnmarshaller.instance()));
            list.add(Pair.of(Byte.TYPE, ByteSetUnmarshaller.instance()));
            list.add(Pair.of(Byte.class, ByteSetUnmarshaller.instance()));
            list.add(Pair.of(Long.TYPE, LongSetUnmarshaller.instance()));
            list.add(Pair.of(Long.class, LongSetUnmarshaller.instance()));
            list.add(Pair.of(Short.TYPE, ShortSetUnmarshaller.instance()));
            list.add(Pair.of(Short.class, ShortSetUnmarshaller.instance()));
            list.add(Pair.of(Boolean.TYPE, BooleanSetUnmarshaller.instance()));
            list.add(Pair.of(Boolean.class, BooleanSetUnmarshaller.instance()));
            list.add(Pair.of(Date.class, DateSetUnmarshaller.instance()));
            list.add(Pair.of(Calendar.class, CalendarSetUnmarshaller.instance()));
            list.add(Pair.of(ByteBuffer.class, ByteBufferSetUnmarshaller.instance()));
            list.add(Pair.of(byte[].class, ByteArraySetUnmarshaller.instance()));
            list.add(Pair.of(String.class, StringSetUnmarshaller.instance()));
            return list;
        }

        @Override
        public ArgumentUnmarshaller getUnmarshaller(Method getter, Method setter) {
            if (setter.getParameterTypes().length != 1) {
                throw new DynamoDBMappingException("Expected exactly one agument to " + setter);
            }
            Class paramType = setter.getParameterTypes()[0];
            if (Set.class.isAssignableFrom(paramType)) {
                paramType = ConversionSchemas.unwrapGenericSetParam(setter.getGenericParameterTypes()[0]);
                return this.getSet(setter, paramType);
            }
            return this.getScalar(setter, paramType);
        }

        @Override
        public ArgumentUnmarshaller getMemberUnmarshaller(Type memberType) {
            Class<?> clazz = ReflectionUtils.resolveClass(memberType);
            if (Set.class.isAssignableFrom(clazz)) {
                Class setMemberType = ConversionSchemas.unwrapGenericSetParam(memberType);
                return this.getSet(null, setMemberType);
            }
            return this.getScalar(null, clazz);
        }

        private ArgumentUnmarshaller getSet(Method setter, Class<?> paramType) {
            ArgumentUnmarshaller unmarshaller = (ArgumentUnmarshaller)ConversionSchemas.find(paramType, this.setUnmarshallers);
            String className = "?";
            String methodName = "?";
            if (setter != null) {
                className = setter.getDeclaringClass().toString();
                methodName = setter.getName();
            }
            if (unmarshaller == null) {
                throw new DynamoDBMappingException("Cannot unmarshall to parameter type Set<" + paramType + "> of method " + className + "." + methodName + " without a custom " + "unmarshaler.");
            }
            return unmarshaller;
        }

        private ArgumentUnmarshaller getScalar(Method setter, Class<?> type) {
            ArgumentUnmarshaller unmarshaller = (ArgumentUnmarshaller)ConversionSchemas.find(type, this.unmarshallers);
            String className = "?";
            String methodName = "?";
            if (setter != null) {
                className = setter.getDeclaringClass().toString();
                methodName = setter.getName();
            }
            if (unmarshaller == null) {
                throw new DynamoDBMappingException("Cannot unmarshall to parameter type " + type + "of method " + className + "." + methodName + " without a custom unmarshaler.");
            }
            return unmarshaller;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AbstractMarshallerSet
    implements MarshallerSet {
        private final List<Pair<ArgumentMarshaller>> marshallers;
        private final List<Pair<ArgumentMarshaller>> setMarshallers;

        public AbstractMarshallerSet(List<Pair<ArgumentMarshaller>> marshallers, List<Pair<ArgumentMarshaller>> setMarshallers) {
            this.marshallers = marshallers;
            this.setMarshallers = setMarshallers;
        }

        @Override
        public ArgumentMarshaller getMarshaller(Method getter) {
            Class<?> returnType = getter.getReturnType();
            if (Set.class.isAssignableFrom(returnType)) {
                Class memberType = ConversionSchemas.unwrapGenericSetParam(getter.getGenericReturnType());
                return this.getSet(getter, memberType);
            }
            return this.getScalar(getter, returnType);
        }

        @Override
        public ArgumentMarshaller getMemberMarshaller(Type memberType) {
            Class<?> clazz = ReflectionUtils.resolveClass(memberType);
            if (Set.class.isAssignableFrom(clazz)) {
                Class setMemberType = ConversionSchemas.unwrapGenericSetParam(memberType);
                return this.getSet(null, setMemberType);
            }
            return this.getScalar(null, clazz);
        }

        private ArgumentMarshaller getScalar(Method getter, Class<?> type) {
            ArgumentMarshaller marshaller = (ArgumentMarshaller)ConversionSchemas.find(type, this.marshallers);
            if (marshaller == null) {
                String className = "?";
                String methodName = "?";
                if (getter != null) {
                    className = getter.getDeclaringClass().toString();
                    methodName = getter.getName();
                }
                throw new DynamoDBMappingException("Cannot marshall return type " + type + " of method " + className + "." + methodName + " without a custom marshaler.");
            }
            return marshaller;
        }

        private ArgumentMarshaller getSet(Method getter, Class<?> memberType) {
            ArgumentMarshaller marshaller = (ArgumentMarshaller)ConversionSchemas.find(memberType, this.setMarshallers);
            if (marshaller == null) {
                String className = "?";
                String methodName = "?";
                if (getter != null) {
                    className = getter.getDeclaringClass().toString();
                    methodName = getter.getName();
                }
                throw new DynamoDBMappingException("Cannot marshall return type Set<" + memberType + "> of method " + className + "." + methodName + " without a custom marshaller.");
            }
            return marshaller;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class V1MarshallerSet
    extends AbstractMarshallerSet {
        public V1MarshallerSet() {
            super(V1MarshallerSet.marshallers(), V1MarshallerSet.setMarshallers());
        }

        private static List<Pair<ArgumentMarshaller>> marshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateMarshallers(list);
            ConversionSchemas.addV1BooleanMarshallers(list);
            ConversionSchemas.addStandardNumberMarshallers(list);
            ConversionSchemas.addStandardStringMarshallers(list);
            ConversionSchemas.addStandardBinaryMarshallers(list);
            ConversionSchemas.addStandardS3LinkMarshallers(list);
            return list;
        }

        private static List<Pair<ArgumentMarshaller>> setMarshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateSetMarshallers(list);
            ConversionSchemas.addV1BooleanSetMarshallers(list);
            ConversionSchemas.addStandardNumberSetMarshallers(list);
            ConversionSchemas.addStandardStringSetMarshallers(list);
            ConversionSchemas.addStandardBinarySetMarshallers(list);
            list.add(Pair.of(Object.class, ObjectSetToStringSetMarshaller.instance()));
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class V2CompatibleMarshallerSet
    extends AbstractMarshallerSet {
        public V2CompatibleMarshallerSet() {
            super(V2CompatibleMarshallerSet.marshallers(), V2CompatibleMarshallerSet.setMarshallers());
        }

        private static List<Pair<ArgumentMarshaller>> marshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateMarshallers(list);
            ConversionSchemas.addV1BooleanMarshallers(list);
            ConversionSchemas.addStandardNumberMarshallers(list);
            ConversionSchemas.addStandardStringMarshallers(list);
            ConversionSchemas.addStandardBinaryMarshallers(list);
            ConversionSchemas.addStandardS3LinkMarshallers(list);
            list.add(Pair.of(List.class, ListToListMarshaller.instance()));
            list.add(Pair.of(Map.class, MapToMapMarshaller.instance()));
            list.add(Pair.of(Object.class, ObjectToMapMarshaller.instance()));
            return list;
        }

        private static List<Pair<ArgumentMarshaller>> setMarshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateSetMarshallers(list);
            ConversionSchemas.addV1BooleanSetMarshallers(list);
            ConversionSchemas.addStandardNumberSetMarshallers(list);
            ConversionSchemas.addStandardStringSetMarshallers(list);
            ConversionSchemas.addStandardBinarySetMarshallers(list);
            list.add(Pair.of(Object.class, ObjectSetToStringSetMarshaller.instance()));
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class V2MarshallerSet
    extends AbstractMarshallerSet {
        public V2MarshallerSet() {
            super(V2MarshallerSet.marshallers(), V2MarshallerSet.setMarshallers());
        }

        private static List<Pair<ArgumentMarshaller>> marshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateMarshallers(list);
            ConversionSchemas.addV2BooleanMarshallers(list);
            ConversionSchemas.addStandardNumberMarshallers(list);
            ConversionSchemas.addStandardStringMarshallers(list);
            ConversionSchemas.addStandardBinaryMarshallers(list);
            ConversionSchemas.addStandardS3LinkMarshallers(list);
            list.add(Pair.of(List.class, ListToListMarshaller.instance()));
            list.add(Pair.of(Map.class, MapToMapMarshaller.instance()));
            list.add(Pair.of(Object.class, ObjectToMapMarshaller.instance()));
            return list;
        }

        private static List<Pair<ArgumentMarshaller>> setMarshallers() {
            ArrayList<Pair<ArgumentMarshaller>> list = new ArrayList<Pair<ArgumentMarshaller>>();
            ConversionSchemas.addStandardDateSetMarshallers(list);
            ConversionSchemas.addStandardNumberSetMarshallers(list);
            ConversionSchemas.addStandardStringSetMarshallers(list);
            ConversionSchemas.addStandardBinarySetMarshallers(list);
            return list;
        }
    }

    static interface UnmarshallerSet {
        public ArgumentUnmarshaller getUnmarshaller(Method var1, Method var2);

        public ArgumentUnmarshaller getMemberUnmarshaller(Type var1);
    }

    static interface MarshallerSet {
        public ArgumentMarshaller getMarshaller(Method var1);

        public ArgumentMarshaller getMemberMarshaller(Type var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StandardItemConverter
    implements ItemConverter {
        private final MarshallerSet marshallerSet;
        private final UnmarshallerSet unmarshallerSet;
        private final DynamoDBReflector reflector;
        private final S3ClientCache s3cc;

        public StandardItemConverter(MarshallerSet marshallerSet, UnmarshallerSet unmarshallerSet, DynamoDBReflector reflector, S3ClientCache s3cc) {
            this.marshallerSet = marshallerSet;
            this.unmarshallerSet = unmarshallerSet;
            this.reflector = reflector;
            this.s3cc = s3cc;
        }

        @Override
        public DynamoDBMapperFieldModel getFieldModel(Method getter) {
            String attributeName = this.reflector.getAttributeName(getter);
            ArgumentMarshaller marshaller = this.getMarshaller(getter);
            DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType = null;
            if (marshaller instanceof ArgumentMarshaller.StringAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.S;
            } else if (marshaller instanceof ArgumentMarshaller.NumberAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.N;
            } else if (marshaller instanceof ArgumentMarshaller.BinaryAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.B;
            } else if (marshaller instanceof ArgumentMarshaller.StringSetAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.SS;
            } else if (marshaller instanceof ArgumentMarshaller.NumberSetAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.NS;
            } else if (marshaller instanceof ArgumentMarshaller.BinarySetAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.BS;
            } else if (marshaller instanceof ArgumentMarshaller.BooleanAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.BOOL;
            } else if (marshaller instanceof ArgumentMarshaller.ListAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.L;
            } else if (marshaller instanceof ArgumentMarshaller.MapAttributeMarshaller) {
                attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.M;
            } else {
                throw new DynamoDBMappingException("Unrecognized marshaller type for " + getter + ": " + marshaller);
            }
            return new DynamoDBMapperFieldModel(attributeName, attributeType, marshaller);
        }

        @Override
        public AttributeValue convert(Method getter, Object object) {
            if (object == null) {
                return null;
            }
            ArgumentMarshaller marshaller = this.getMarshaller(getter);
            return marshaller.marshall(object);
        }

        @Override
        public Map<String, AttributeValue> convert(Object object) {
            if (object == null) {
                return null;
            }
            Class<?> clazz = object.getClass();
            HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
            for (Method getter : this.reflector.getRelevantGetters(clazz)) {
                AttributeValue value;
                Object getterResult = ReflectionUtils.safeInvoke(getter, object, new Object[0]);
                if (getterResult == null || (value = this.convert(getter, getterResult)) == null) continue;
                String name = this.reflector.getAttributeName(getter);
                result.put(name, value);
            }
            return result;
        }

        private ArgumentMarshaller getMarshaller(Method getter) {
            ArgumentMarshaller marshaller = this.marshallerSet.getMarshaller(getter);
            marshaller = this.augment(getter.getGenericReturnType(), marshaller);
            return marshaller;
        }

        private ArgumentMarshaller getMemberMarshaller(Type type) {
            ArgumentMarshaller marshaller = this.marshallerSet.getMemberMarshaller(type);
            marshaller = this.augment(type, marshaller);
            return marshaller;
        }

        private ArgumentMarshaller augment(Type type, ArgumentMarshaller marshaller) {
            if (marshaller instanceof ListToListMarshaller) {
                return this.getListToListMarshaller(type);
            }
            if (marshaller instanceof MapToMapMarshaller) {
                return this.getMapToMapMarshaller(type);
            }
            if (marshaller instanceof ObjectToMapMarshaller) {
                return this.getObjectToMapMarshaller(type);
            }
            return marshaller;
        }

        private ArgumentMarshaller getListToListMarshaller(Type type) {
            if (!(type instanceof ParameterizedType)) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the List type " + type + ", which is not parameterized.");
            }
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            if (args == null || args.length != 1) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the List type " + type + "; unexpected number of type " + "arguments.");
            }
            ArgumentMarshaller memberMarshaller = this.getMemberMarshaller(args[0]);
            return new ListToListMarshaller(memberMarshaller);
        }

        private ArgumentMarshaller getMapToMapMarshaller(Type type) {
            if (!(type instanceof ParameterizedType)) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the Map type " + type + ", which is not parameterized.");
            }
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            if (args == null || args.length != 2) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the Map type " + type + "; unexpected number of type " + "arguments.");
            }
            if (args[0] != String.class) {
                throw new DynamoDBMappingException("Only Map<String, ?> is supported.");
            }
            ArgumentMarshaller memberMarshaller = this.getMemberMarshaller(args[1]);
            return new MapToMapMarshaller(memberMarshaller);
        }

        private ArgumentMarshaller getObjectToMapMarshaller(Type type) {
            Type localType = type;
            if (localType instanceof ParameterizedType) {
                localType = ((ParameterizedType)localType).getRawType();
            }
            if (!(localType instanceof Class)) {
                throw new DynamoDBMappingException("Cannot convert " + type + " to a class");
            }
            Class clazz = (Class)localType;
            if (clazz.getAnnotation(DynamoDBDocument.class) == null) {
                throw new DynamoDBMappingException("Cannot marshall type " + type + " without a custom marshaler or @DynamoDBDocument " + "annotation.");
            }
            return new ObjectToMapMarshaller(this);
        }

        @Override
        public Object unconvert(Method getter, Method setter, AttributeValue value) {
            ArgumentUnmarshaller unmarshaller = this.getUnmarshaller(getter, setter);
            return StandardItemConverter.unmarshall(unmarshaller, setter, value);
        }

        @Override
        public <T> T unconvert(Class<T> clazz, Map<String, AttributeValue> value) {
            T result = StandardItemConverter.createObject(clazz);
            if (value == null || value.isEmpty()) {
                return result;
            }
            for (Method m : this.reflector.getRelevantGetters(clazz)) {
                String attributeName = this.reflector.getAttributeName(m);
                AttributeValue av = value.get(attributeName);
                if (av == null) continue;
                this.setValue(result, m, av);
            }
            return result;
        }

        private void setValue(Object target, Method getter, AttributeValue value) {
            Method setter = this.reflector.getSetter(getter);
            ArgumentUnmarshaller unmarshaller = this.getUnmarshaller(getter, setter);
            Object unmarshalled = StandardItemConverter.unmarshall(unmarshaller, setter, value);
            ReflectionUtils.safeInvoke(setter, target, unmarshalled);
        }

        private ArgumentUnmarshaller getUnmarshaller(Method getter, Method setter) {
            ArgumentUnmarshaller unmarshaller = this.unmarshallerSet.getUnmarshaller(getter, setter);
            unmarshaller = this.augment(setter.getGenericParameterTypes()[0], unmarshaller);
            return new NullableUnmarshaller(unmarshaller);
        }

        private ArgumentUnmarshaller getMemberUnmarshaller(Type type) {
            ArgumentUnmarshaller unmarshaller = this.unmarshallerSet.getMemberUnmarshaller(type);
            unmarshaller = this.augment(type, unmarshaller);
            return new NullableUnmarshaller(unmarshaller);
        }

        private ArgumentUnmarshaller augment(Type type, ArgumentUnmarshaller unmarshaller) {
            if (unmarshaller instanceof S3LinkUnmarshaller) {
                return new S3LinkUnmarshaller(this.s3cc);
            }
            if (unmarshaller instanceof ListUnmarshaller) {
                return this.getListUnmarshaller(type);
            }
            if (unmarshaller instanceof MapUnmarshaller) {
                return this.getMapUnmarshaller(type);
            }
            if (unmarshaller instanceof ObjectUnmarshaller) {
                return this.getObjectUnmarshaller(type);
            }
            return unmarshaller;
        }

        private ArgumentUnmarshaller getListUnmarshaller(Type type) {
            if (!(type instanceof ParameterizedType)) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the List type " + type + ", which is not parameterized.");
            }
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            if (args == null || args.length != 1) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the List type " + type + "; unexpected number of type " + "arguments.");
            }
            ArgumentUnmarshaller memberUnmarshaller = this.getMemberUnmarshaller(args[0]);
            return new ListUnmarshaller(memberUnmarshaller);
        }

        private ArgumentUnmarshaller getMapUnmarshaller(Type type) {
            if (!(type instanceof ParameterizedType)) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the Map type " + type + ", which is not parameterized.");
            }
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            if (args == null || args.length != 2) {
                throw new DynamoDBMappingException("Cannot tell what type of objects belong in the Map type " + type + "; unexpected number of type " + "arguments.");
            }
            if (args[0] != String.class) {
                throw new DynamoDBMappingException("Only Map<String, ?> is supported.");
            }
            ArgumentUnmarshaller memberUnmarshaller = this.getMemberUnmarshaller(args[1]);
            return new MapUnmarshaller(memberUnmarshaller);
        }

        private ArgumentUnmarshaller getObjectUnmarshaller(Type type) {
            Type localType = type;
            if (localType instanceof ParameterizedType) {
                localType = ((ParameterizedType)type).getRawType();
            }
            if (!(localType instanceof Class)) {
                throw new DynamoDBMappingException("Cannot convert " + type + " to a class");
            }
            Class clazz = (Class)localType;
            if (clazz.getAnnotation(DynamoDBDocument.class) == null) {
                throw new DynamoDBMappingException("Cannot unmarshall to type " + type + " without a custom marshaler or @DynamoDBDocument " + "annotation.");
            }
            return new ObjectUnmarshaller(this, clazz);
        }

        private static Object unmarshall(ArgumentUnmarshaller unmarshaller, Method setter, AttributeValue value) {
            unmarshaller.typeCheck(value, setter);
            try {
                return unmarshaller.unmarshall(value);
            }
            catch (IllegalArgumentException e) {
                throw new DynamoDBMappingException("Couldn't unmarshall value " + value + " for " + setter, e);
            }
            catch (ParseException e) {
                throw new DynamoDBMappingException("Error attempting to parse date string " + value + " for " + setter, e);
            }
        }

        private static <T> T createObject(Class<T> clazz) {
            try {
                return clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new DynamoDBMappingException("Failed to instantiate new instance of class", e);
            }
            catch (IllegalAccessException e) {
                throw new DynamoDBMappingException("Failed to instantiate new instance of class", e);
            }
        }
    }

    static class StandardConversionSchema
    implements ConversionSchema {
        private final String name;
        private final MarshallerSet marshallers;
        private final UnmarshallerSet unmarshallers;

        public StandardConversionSchema(String name, MarshallerSet marshallers, UnmarshallerSet unmarshallers) {
            this.name = name;
            this.marshallers = new CachingMarshallerSet(new AnnotationAwareMarshallerSet(marshallers));
            this.unmarshallers = new CachingUnmarshallerSet(new AnnotationAwareUnmarshallerSet(unmarshallers));
        }

        public ItemConverter getConverter(ConversionSchema.Dependencies dependencies) {
            DynamoDBReflector reflector = dependencies.get(DynamoDBReflector.class);
            if (reflector == null) {
                reflector = new DynamoDBReflector();
            }
            S3ClientCache s3cc = dependencies.get(S3ClientCache.class);
            return new StandardItemConverter(this.marshallers, this.unmarshallers, reflector, s3cc);
        }

        public String toString() {
            return this.name;
        }
    }
}

