/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper;

import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMarshaller;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonMarshaller<T>
implements DynamoDBMarshaller<T> {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectWriter writer = mapper.writer();

    @Override
    public String marshall(T obj) {
        try {
            return writer.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to marshall the instance of " + obj.getClass() + "into a string", e);
        }
    }

    @Override
    public T unmarshall(Class<T> clazz, String json) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to unmarshall the string " + json + "into " + clazz, e);
        }
    }
}

