/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper;

import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMapper;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PaginatedList<T>
implements List<T> {
    private static final String UNMODIFIABLE_MESSAGE = "This is an unmodifiable list";
    private static final String ITERATION_ONLY_UNSUPPORTED_OPERATION_MESSAGE = " is not supported when using ITERATION_ONLY configuration.";
    protected final DynamoDBMapper mapper;
    protected final Class<T> clazz;
    protected final AmazonDynamoDB dynamo;
    protected boolean allResultsLoaded = false;
    protected final List<T> allResults;
    protected final List<T> nextResults = new LinkedList<T>();
    private final DynamoDBMapperConfig.PaginationLoadingStrategy paginationLoadingStrategy;
    private boolean iterationStarted = false;

    public PaginatedList(DynamoDBMapper mapper, Class<T> clazz, AmazonDynamoDB dynamo) {
        this(mapper, clazz, dynamo, null);
    }

    public PaginatedList(DynamoDBMapper mapper, Class<T> clazz, AmazonDynamoDB dynamo, DynamoDBMapperConfig.PaginationLoadingStrategy paginationLoadingStrategy) {
        this.mapper = mapper;
        this.clazz = clazz;
        this.dynamo = dynamo;
        this.paginationLoadingStrategy = paginationLoadingStrategy == null ? DynamoDBMapperConfig.PaginationLoadingStrategy.LAZY_LOADING : paginationLoadingStrategy;
        this.allResults = new ArrayList<T>();
    }

    public synchronized void loadAllResults() {
        this.checkUnsupportedOperationForIterationOnlyMode("loadAllResults()");
        if (this.allResultsLoaded) {
            return;
        }
        while (this.nextResultsAvailable()) {
            this.moveNextResults(false);
        }
        this.allResultsLoaded = true;
    }

    private boolean nextResultsAvailable() {
        return !this.nextResults.isEmpty() || this.loadNextResults();
    }

    private synchronized boolean loadNextResults() {
        if (this.atEndOfResults()) {
            return false;
        }
        do {
            this.nextResults.addAll(this.fetchNextPage());
        } while (!this.atEndOfResults() && this.nextResults.isEmpty());
        return !this.nextResults.isEmpty();
    }

    private void moveNextResults(boolean clearPreviousResults) {
        if (clearPreviousResults) {
            this.allResults.clear();
        }
        this.allResults.addAll(this.nextResults);
        this.nextResults.clear();
    }

    protected abstract List<T> fetchNextPage();

    protected abstract boolean atEndOfResults();

    @Override
    public Iterator<T> iterator() {
        return new PaginatedListIterator(this.paginationLoadingStrategy == DynamoDBMapperConfig.PaginationLoadingStrategy.ITERATION_ONLY);
    }

    @Override
    public boolean isEmpty() {
        this.checkUnsupportedOperationForIterationOnlyMode("isEmpty()");
        return !this.iterator().hasNext();
    }

    @Override
    public T get(int n) {
        this.checkUnsupportedOperationForIterationOnlyMode("get(int n)");
        while (this.allResults.size() <= n && this.nextResultsAvailable()) {
            this.moveNextResults(false);
        }
        return this.allResults.get(n);
    }

    @Override
    public boolean contains(Object arg0) {
        this.checkUnsupportedOperationForIterationOnlyMode("contains(Object arg0)");
        if (this.allResults.contains(arg0)) {
            return true;
        }
        while (this.nextResultsAvailable()) {
            boolean found = this.nextResults.contains(arg0);
            this.moveNextResults(false);
            if (!found) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> subList(int arg0, int arg1) {
        this.checkUnsupportedOperationForIterationOnlyMode("subList(int arg0, int arg1)");
        while (this.allResults.size() < arg1 && this.nextResultsAvailable()) {
            this.moveNextResults(false);
        }
        return Collections.unmodifiableList(this.allResults.subList(arg0, arg1));
    }

    @Override
    public int indexOf(Object arg0) {
        this.checkUnsupportedOperationForIterationOnlyMode("indexOf(Object org0)");
        int indexOf = this.allResults.indexOf(arg0);
        if (indexOf >= 0) {
            return indexOf;
        }
        while (this.nextResultsAvailable()) {
            indexOf = this.nextResults.indexOf(arg0);
            int size = this.allResults.size();
            this.moveNextResults(false);
            if (indexOf < 0) continue;
            return indexOf + size;
        }
        return -1;
    }

    @Override
    public int size() {
        this.loadAllResults();
        return this.allResults.size();
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        this.loadAllResults();
        return this.allResults.containsAll(arg0);
    }

    @Override
    public int lastIndexOf(Object arg0) {
        this.loadAllResults();
        return this.allResults.lastIndexOf(arg0);
    }

    @Override
    public Object[] toArray() {
        this.loadAllResults();
        return this.allResults.toArray();
    }

    @Override
    public <X> X[] toArray(X[] a) {
        this.loadAllResults();
        return this.allResults.toArray(a);
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("ListIterators are not supported for this list");
    }

    @Override
    public ListIterator<T> listIterator(int arg0) {
        throw new UnsupportedOperationException("ListIterators are not supported for this list");
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public T remove(int arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public T set(int arg0, T arg1) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean add(T arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public void add(int arg0, T arg1) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends T> arg1) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    private void checkUnsupportedOperationForIterationOnlyMode(String methodSignature) {
        if (this.paginationLoadingStrategy == DynamoDBMapperConfig.PaginationLoadingStrategy.ITERATION_ONLY) {
            throw new UnsupportedOperationException(methodSignature + ITERATION_ONLY_UNSUPPORTED_OPERATION_MESSAGE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PaginatedListIterator
    implements Iterator<T> {
        private final boolean iterationOnly;
        private final List<T> allResultsCopy;
        private Iterator<T> innerIterator;
        private int pos = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PaginatedListIterator(boolean iterationOnly) {
            this.iterationOnly = iterationOnly;
            if (iterationOnly) {
                PaginatedList paginatedList2 = PaginatedList.this;
                synchronized (paginatedList2) {
                    if (PaginatedList.this.iterationStarted) {
                        throw new UnsupportedOperationException("The list could only be iterated once in ITERATION_ONLY mode.");
                    }
                    PaginatedList.this.iterationStarted = true;
                }
                this.allResultsCopy = null;
                this.innerIterator = PaginatedList.this.allResults.iterator();
            } else {
                this.allResultsCopy = new ArrayList();
                this.allResultsCopy.addAll(PaginatedList.this.allResults);
                this.innerIterator = this.allResultsCopy.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.innerIterator.hasNext() || PaginatedList.this.nextResultsAvailable();
        }

        @Override
        public T next() {
            if (!this.innerIterator.hasNext()) {
                if (this.iterationOnly || PaginatedList.this.allResults.size() == this.allResultsCopy.size()) {
                    if (!PaginatedList.this.nextResultsAvailable()) {
                        throw new NoSuchElementException();
                    }
                    boolean clearPreviousResults = this.iterationOnly;
                    PaginatedList.this.moveNextResults(clearPreviousResults);
                }
                if (this.iterationOnly) {
                    this.innerIterator = PaginatedList.this.allResults.iterator();
                } else {
                    if (PaginatedList.this.allResults.size() > this.allResultsCopy.size()) {
                        this.allResultsCopy.addAll(PaginatedList.this.allResults.subList(this.allResultsCopy.size(), PaginatedList.this.allResults.size()));
                    }
                    this.innerIterator = this.allResultsCopy.listIterator(this.pos);
                }
            }
            ++this.pos;
            return this.innerIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(PaginatedList.UNMODIFIABLE_MESSAGE);
        }
    }
}

