/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper;

import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMapper;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMapperConfig;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.PaginatedList;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginatedQueryList<T>
extends PaginatedList<T> {
    private final QueryRequest queryRequest;
    private final DynamoDBMapperConfig config;
    private QueryResult queryResult;

    public PaginatedQueryList(DynamoDBMapper mapper, Class<T> clazz, AmazonDynamoDB dynamo, QueryRequest queryRequest, QueryResult queryResult, DynamoDBMapperConfig.PaginationLoadingStrategy paginationLoadingStrategy, DynamoDBMapperConfig config) {
        super(mapper, clazz, dynamo, paginationLoadingStrategy);
        this.queryRequest = queryRequest;
        this.queryResult = queryResult;
        this.config = config;
        this.allResults.addAll(mapper.marshallIntoObjects(mapper.toParameters(queryResult.getItems(), clazz, queryRequest.getTableName(), config)));
        if (paginationLoadingStrategy == DynamoDBMapperConfig.PaginationLoadingStrategy.EAGER_LOADING) {
            this.loadAllResults();
        }
    }

    @Override
    protected boolean atEndOfResults() {
        return this.queryResult.getLastEvaluatedKey() == null;
    }

    @Override
    protected synchronized List<T> fetchNextPage() {
        this.queryRequest.setExclusiveStartKey(this.queryResult.getLastEvaluatedKey());
        this.queryResult = this.dynamo.query(DynamoDBMapper.applyUserAgent(this.queryRequest));
        return this.mapper.marshallIntoObjects(this.mapper.toParameters(this.queryResult.getItems(), this.clazz, this.queryRequest.getTableName(), this.config));
    }
}

