/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper;

import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMappingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReflectionUtils {
    ReflectionUtils() {
    }

    static Object safeInvoke(Method method, Object object, Object ... arguments) {
        try {
            return method.invoke(object, arguments);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDBMappingException("Couldn't invoke " + method, e);
        }
        catch (IllegalArgumentException e) {
            throw new DynamoDBMappingException("Couldn't invoke " + method, e);
        }
        catch (InvocationTargetException e) {
            throw new DynamoDBMappingException("Couldn't invoke " + method, e);
        }
    }

    static String getFieldNameByGetter(Method getter, boolean forceCamelCase) {
        String getterName = getter.getName();
        String fieldNameWithUpperCamelCase = "";
        if (getterName.startsWith("get")) {
            fieldNameWithUpperCamelCase = getterName.substring("get".length());
        } else if (getterName.startsWith("is")) {
            fieldNameWithUpperCamelCase = getterName.substring("is".length());
        }
        if (fieldNameWithUpperCamelCase.length() == 0) {
            throw new DynamoDBMappingException("Getter must begin with 'get' or 'is', and the field name must contain at least one character.");
        }
        if (forceCamelCase) {
            return fieldNameWithUpperCamelCase.substring(0, 1).toLowerCase() + fieldNameWithUpperCamelCase.substring(1);
        }
        return fieldNameWithUpperCamelCase;
    }

    static Field getClassFieldByName(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (SecurityException e) {
            throw new DynamoDBMappingException("Denied access to the [" + fieldName + "] field in class [" + clazz + "].", e);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    static <T extends Annotation> T getAnnotationFromGetterOrField(Method getter, Class<T> annotationClass) {
        T onGetter = getter.getAnnotation(annotationClass);
        if (onGetter != null) {
            return onGetter;
        }
        String fieldName = ReflectionUtils.getFieldNameByGetter(getter, true);
        Field field = ReflectionUtils.getClassFieldByName(getter.getDeclaringClass(), fieldName);
        T onField = null;
        if (field != null) {
            onField = field.getAnnotation(annotationClass);
        }
        return onField;
    }

    static <T extends Annotation> boolean getterOrFieldHasAnnotation(Method getter, Class<T> annotationClass) {
        return ReflectionUtils.getAnnotationFromGetterOrField(getter, annotationClass) != null;
    }

    static Class<?> resolveClass(Type type) {
        Type localType = type;
        if (localType instanceof ParameterizedType) {
            localType = ((ParameterizedType)type).getRawType();
        }
        if (!(localType instanceof Class)) {
            throw new DynamoDBMappingException("Cannot resolve class for type " + type);
        }
        return (Class)localType;
    }
}

