/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper;

import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMappingException;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBVersionAttribute;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VersionIncrementor {
    private final Map<Method, Incrementor> cache = new HashMap<Method, Incrementor>();
    private static final Incrementor BIG_INTEGER = new Incrementor(){

        public Object increment(Object o) {
            if (o == null) {
                return BigInteger.ONE;
            }
            return ((BigInteger)o).add(BigInteger.ONE);
        }
    };
    private static final Incrementor LONG = new Incrementor(){

        public Object increment(Object o) {
            if (o == null) {
                return 1L;
            }
            long next = (Long)o + 1L;
            return next;
        }
    };
    private static final Incrementor INTEGER = new Incrementor(){

        public Object increment(Object o) {
            if (o == null) {
                return 1;
            }
            int next = (Integer)o + 1;
            return next;
        }
    };
    private static final Incrementor SHORT = new Incrementor(){

        public Object increment(Object o) {
            if (o == null) {
                return (short)1;
            }
            short next = (short)((Short)o + 1);
            return next;
        }
    };
    private static final Incrementor BYTE = new Incrementor(){

        public Object increment(Object o) {
            if (o == null) {
                return (byte)1;
            }
            byte next = (byte)(((Byte)o + 1) % 127);
            return next;
        }
    };

    VersionIncrementor() {
    }

    public Object increment(Method getter, Object object) {
        Incrementor incrementor = this.getIncrementor(getter);
        return incrementor.increment(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Incrementor getIncrementor(Method getter) {
        Map<Method, Incrementor> map = this.cache;
        synchronized (map) {
            Incrementor result = this.cache.get(getter);
            if (result != null) {
                return result;
            }
            Class<?> returnType = getter.getReturnType();
            if (VersionIncrementor.matches(returnType, BigInteger.class)) {
                result = BIG_INTEGER;
            } else if (VersionIncrementor.matches(returnType, Long.class, Long.TYPE)) {
                result = LONG;
            } else if (VersionIncrementor.matches(returnType, Integer.class, Integer.TYPE)) {
                result = INTEGER;
            } else if (VersionIncrementor.matches(returnType, Short.class, Short.TYPE)) {
                result = SHORT;
            } else if (VersionIncrementor.matches(returnType, Byte.class, Byte.TYPE)) {
                result = BYTE;
            } else {
                throw new DynamoDBMappingException("Unsupported parameter type for " + DynamoDBVersionAttribute.class + ": " + returnType + ". Must be a whole-number type.");
            }
            this.cache.put(getter, result);
            return result;
        }
    }

    private static boolean matches(Class<?> needle, Class<?> ... haystack) {
        for (Class<?> clazz : haystack) {
            if (!clazz.isAssignableFrom(needle)) continue;
            return true;
        }
        return false;
    }

    private static interface Incrementor {
        public Object increment(Object var1);
    }
}

