/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers;

import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.ArgumentMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMappingException;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMarshaller;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomMarshaller
implements ArgumentMarshaller.StringAttributeMarshaller {
    private final Class<? extends DynamoDBMarshaller<?>> marshallerClass;

    public CustomMarshaller(Class<? extends DynamoDBMarshaller<?>> marshallerClass) {
        this.marshallerClass = marshallerClass;
    }

    @Override
    public AttributeValue marshall(Object obj) {
        DynamoDBMarshaller<Object> marshaler = CustomMarshaller.createMarshaller(this.marshallerClass);
        String stringValue = marshaler.marshall(obj);
        if (stringValue == null) {
            return null;
        }
        return new AttributeValue(stringValue);
    }

    private static DynamoDBMarshaller<Object> createMarshaller(Class<?> clazz) {
        try {
            return (DynamoDBMarshaller)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new DynamoDBMappingException("Failed to instantiate custom marshaler for class " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDBMappingException("Failed to instantiate custom marshaler for class " + clazz, e);
        }
    }
}

