/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.marshallers;

import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.ArgumentMarshaller;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectSetToStringSetMarshaller
implements ArgumentMarshaller.StringSetAttributeMarshaller {
    private static final Log LOG = LogFactory.getLog(ObjectSetToStringSetMarshaller.class);
    private static final ObjectSetToStringSetMarshaller INSTANCE = new ObjectSetToStringSetMarshaller();

    public static ObjectSetToStringSetMarshaller instance() {
        return INSTANCE;
    }

    private ObjectSetToStringSetMarshaller() {
    }

    public AttributeValue marshall(Object obj) {
        Set set = (Set)obj;
        LOG.warn((Object)"Marshaling a set of non-String objects to a DynamoDB StringSet. You won't be able to read these objects back out of DynamoDB unless you REALLY know what you're doing: it's probably a bug. If you DO know what you're doing feelfree to ignore this warning, but consider using a custom marshaler for this instead.");
        ArrayList<String> strings = new ArrayList<String>(set.size());
        for (Object o : set) {
            strings.add(String.valueOf(o));
        }
        return new AttributeValue().withSS(strings);
    }
}

