/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers;

import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.ArgumentUnmarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.lang.reflect.Method;

public class BooleanUnmarshaller
implements ArgumentUnmarshaller {
    private static final BooleanUnmarshaller INSTANCE = new BooleanUnmarshaller();

    public static BooleanUnmarshaller instance() {
        return INSTANCE;
    }

    private BooleanUnmarshaller() {
    }

    public void typeCheck(AttributeValue value, Method setter) {
        if (value.getN() == null && value.getBOOL() == null) {
            throw new DynamoDBMappingException("Expected either N or BOOL in value " + value + " when invoking " + setter);
        }
    }

    public Object unmarshall(AttributeValue value) {
        if (value.getBOOL() != null) {
            return value.getBOOL();
        }
        if ("1".equals(value.getN())) {
            return Boolean.TRUE;
        }
        if ("0".equals(value.getN())) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Expected '1', '0', or BOOL value for boolean value, was " + value);
    }
}

