/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers;

import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMappingException;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.DynamoDBMarshaller;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.SUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomUnmarshaller
extends SUnmarshaller {
    private final Class<?> targetClass;
    private final Class<? extends DynamoDBMarshaller<?>> unmarshallerClass;

    public CustomUnmarshaller(Class<?> targetClass, Class<? extends DynamoDBMarshaller<?>> unmarshallerClass) {
        this.targetClass = targetClass;
        this.unmarshallerClass = unmarshallerClass;
    }

    @Override
    public Object unmarshall(AttributeValue value) {
        DynamoDBMarshaller unmarshaller = CustomUnmarshaller.createUnmarshaller(this.unmarshallerClass);
        return unmarshaller.unmarshall(this.targetClass, value.getS());
    }

    private static DynamoDBMarshaller createUnmarshaller(Class<?> clazz) {
        try {
            return (DynamoDBMarshaller)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new DynamoDBMappingException("Failed to instantiate custom marshaler for class " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDBMappingException("Failed to instantiate custom marshaler for class " + clazz, e);
        }
    }
}

