/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers;

import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.S3ClientCache;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.S3Link;
import com.amazonaws.mobileconnectors.dynamodbv2.dynamodbmapper.unmarshallers.SUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;

public class S3LinkUnmarshaller
extends SUnmarshaller {
    private static final S3LinkUnmarshaller INSTANCE = new S3LinkUnmarshaller();
    private final S3ClientCache clientCache;

    public static S3LinkUnmarshaller instance() {
        return INSTANCE;
    }

    private S3LinkUnmarshaller() {
        this(null);
    }

    public S3LinkUnmarshaller(S3ClientCache clientCache) {
        this.clientCache = clientCache;
    }

    public Object unmarshall(AttributeValue value) {
        if (this.clientCache == null) {
            throw new IllegalStateException("Mapper must be constructed with S3 AWS Credentials to load S3Link");
        }
        return S3Link.fromJson(this.clientCache, value.getS());
    }
}

