/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder;

import android.util.Log;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.KinesisRecorderConfig;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.FileRecordStore;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.JSONRecordAdapter;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.RecordStore;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import com.amazonaws.services.kinesis.model.PutRecordsResultEntry;
import com.amazonaws.util.VersionInfoUtils;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KinesisRecorder {
    private static final String TAG = "KinesisRecorder";
    private RecordStore recordStore;
    private JSONRecordAdapter adapter;
    private AmazonKinesisClient client;
    private KinesisRecorderConfig config;
    private File directory;
    private static final String USER_AGENT = KinesisRecorder.class.getName() + "/" + VersionInfoUtils.getVersion();

    public KinesisRecorder(File directory, Regions region, AWSCredentialsProvider credentialsProvider) {
        this(directory, region, credentialsProvider, new KinesisRecorderConfig());
    }

    public KinesisRecorder(File directory, Regions region, AWSCredentialsProvider credentialsProvider, KinesisRecorderConfig config) {
        if (directory == null || credentialsProvider == null || region == null || config == null) {
            throw new IllegalArgumentException("You must pass a non-null credentialsProvider, region, directory, and config to KinesisRecordStore");
        }
        this.config = new KinesisRecorderConfig(config);
        this.directory = directory;
        this.recordStore = new FileRecordStore(directory, this.config);
        this.adapter = new JSONRecordAdapter();
        this.client = new AmazonKinesisClient(credentialsProvider, this.config.getClientConfiguration());
        this.client.setRegion(Region.getRegion(region));
    }

    public void saveRecord(byte[] data, String streamName) {
        if (streamName == null || streamName.isEmpty() || data == null || data.length < 1) {
            throw new IllegalArgumentException("You must pass a non-null, non-empty stream name and non-empty data");
        }
        PutRecordRequest putRequest = new PutRecordRequest().withData(ByteBuffer.wrap(data)).withStreamName(streamName).withPartitionKey(UUID.randomUUID().toString());
        this.recordStore.put(this.adapter.translateFromRecord(putRequest).toString());
    }

    public synchronized void submitAllRecords() {
        RecordStore.RecordIterator iterator = this.recordStore.iterator();
        LinkedList<PutRecordsRequestEntry> entries = new LinkedList<PutRecordsRequestEntry>();
        String stream = null;
        JSONObject json = null;
        while (iterator.hasNext()) {
            try {
                if (json == null) {
                    json = new JSONObject(iterator.peek());
                }
                if (entries.size() == 0) {
                    stream = JSONRecordAdapter.getStreamName(json);
                }
                if (this.belongsInBatch(json, stream, entries)) {
                    entries.add(new PutRecordsRequestEntry().withData(JSONRecordAdapter.getData(json)).withPartitionKey(JSONRecordAdapter.getPartitionKey(json)));
                    json = null;
                    iterator.next();
                    continue;
                }
                this.submitAndUpdate(stream, entries, iterator);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Record in record store was improperly formatted JSON, record will be dropped", (Throwable)e);
                json = null;
                iterator.next();
            }
        }
        if (entries.size() > 0) {
            this.submitAndUpdate(stream, entries, iterator);
        }
    }

    public synchronized void deleteAllRecords() {
        this.recordStore.iterator().removeAllRecords();
    }

    public long getDiskBytesUsed() {
        return this.getRecursiveSizeOfDirectory(this.directory);
    }

    private long getRecursiveSizeOfDirectory(File file) {
        if (!file.isDirectory()) {
            return this.directory.length();
        }
        long totalBytes = 0L;
        for (File subFile : file.listFiles()) {
            if (subFile.isFile()) {
                totalBytes += subFile.length();
                continue;
            }
            if (!subFile.isDirectory()) continue;
            totalBytes += this.getRecursiveSizeOfDirectory(subFile);
        }
        return totalBytes;
    }

    public long getDiskByteLimit() {
        return this.config.getMaxStorageSize();
    }

    public KinesisRecorderConfig getKinesisRecorderConfig() {
        return this.config;
    }

    private boolean belongsInBatch(JSONObject entry, String stream, Collection<PutRecordsRequestEntry> entries) throws JSONException {
        boolean fromSameStream = entries.size() == 0 || JSONRecordAdapter.getStreamName(entry).equals(stream);
        boolean hasSpace = entries.size() + 1 <= 100;
        return fromSameStream && hasSpace;
    }

    private boolean isRecoverable(AmazonServiceException e) {
        String errorCode = e.getErrorCode();
        return !errorCode.equalsIgnoreCase("ValidationError") && !errorCode.equalsIgnoreCase("MissingParameter") && !errorCode.equalsIgnoreCase("MissingAction") && !errorCode.equalsIgnoreCase("MalformedQueryString") && !errorCode.equalsIgnoreCase("InvalidQueryParameter") && !errorCode.equalsIgnoreCase("InvalidParameterValue") && !errorCode.equalsIgnoreCase("InvalidParameterCombination");
    }

    private void saveEntries(String stream, Collection<PutRecordsRequestEntry> entries) {
        for (PutRecordsRequestEntry entry : entries) {
            this.saveEntry(stream, entry);
        }
    }

    private void saveEntry(String stream, PutRecordsRequestEntry entry) {
        this.saveRecord(entry.getData().array(), stream);
    }

    private void submit(String stream, List<PutRecordsRequestEntry> entries) {
        PutRecordsRequest request = new PutRecordsRequest().withStreamName(stream).withRecords(entries);
        try {
            PutRecordsResult result = this.client.putRecords(request);
            for (int i = 0; i < result.getRecords().size(); ++i) {
                PutRecordsResultEntry entry = result.getRecords().get(i);
                if (entry.getErrorCode() == null || entry.getErrorCode().isEmpty()) continue;
                this.saveEntry(stream, entries.get(i));
            }
        }
        catch (AmazonClientException e) {
            if (PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION.shouldRetry(request, e, 1)) {
                Log.w((String)TAG, (String)"Error occured while sending request, request appears to be valid stopping submission but retaining records", (Throwable)e);
                this.saveEntries(stream, entries);
            } else if (e instanceof AmazonServiceException) {
                if (!this.isRecoverable((AmazonServiceException)e)) {
                    Log.e((String)TAG, (String)"ServiceException in submit all, the last request is presumed to be the cause and will be dropped", (Throwable)e);
                } else {
                    this.saveEntries(stream, entries);
                    Log.e((String)TAG, (String)"ServiceException in submit all, the values of the data inside the requests appears valid.  The request will be kept", (Throwable)e);
                }
            }
            throw e;
        }
    }

    private void submitAndUpdate(String stream, List<PutRecordsRequestEntry> entries, RecordStore.RecordIterator iterator) {
        iterator.removeReadRecords();
        this.submit(stream, entries);
        entries.clear();
    }
}

