/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.KinesisRecorderConfig;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.FileManager;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.RecordStore;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.locks.ReentrantLock;

public class FileRecordStore
implements RecordStore {
    private static final Logger logger = Logger.getLogger(FileRecordStore.class);
    static final String KEY_MAX_STORAGE_SIZE = "maxStorageSize";
    static final double ERROR_LENGTH_THRESHOLD_PERCENTAGE = 1.1;
    private final ReentrantLock accessLock = new ReentrantLock(true);
    private File recordFile;
    private FileManager fileManager;
    private KinesisRecorderConfig config;

    public FileRecordStore(File recorderDirectory, KinesisRecorderConfig config) {
        this.fileManager = new FileManager(recorderDirectory);
        this.config = config;
        this.tryCreateRecordsFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(String record) {
        boolean success = false;
        Writer writer = null;
        this.accessLock.lock();
        try {
            block5: {
                try {
                    writer = this.tryInitializeWriter();
                    if (writer == null) break block5;
                    if (this.recordFile.length() + (long)record.getBytes().length <= this.config.getMaxStorageSize()) {
                        writer.write(record + "\n");
                        writer.flush();
                        success = true;
                        break block5;
                    }
                    logger.e("The record file exceeded its allowed size of " + this.config.getMaxStorageSize() + " bytes");
                }
                catch (IOException e) {
                    logger.e("Failed to persist the record", e);
                    Object var6_5 = null;
                    this.accessLock.unlock();
                    this.tryCloseWriter(writer);
                }
            }
            Object var6_4 = null;
            this.accessLock.unlock();
            this.tryCloseWriter(writer);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.accessLock.unlock();
            this.tryCloseWriter(writer);
            throw throwable;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryCreateRecordsFile() {
        if (this.recordFile != null && this.recordFile.exists()) {
            return true;
        }
        FileRecordStore fileRecordStore = this;
        synchronized (fileRecordStore) {
            if (this.recordFile != null && this.recordFile.exists()) {
                return true;
            }
            try {
                File recordDir = this.fileManager.createDirectory("KinesisRecorder");
                this.recordFile = this.fileManager.createFile(new File(recordDir, "KinesisRecords"));
                return true;
            }
            catch (IOException e) {
                logger.deve("Unable to open records file");
                logger.e("An error occurred while attempting to create/open the records file", e);
                return false;
            }
        }
    }

    private Writer tryInitializeWriter() {
        OutputStreamWriter writer = null;
        try {
            if (!this.tryCreateRecordsFile()) {
                throw new AmazonClientException("Unable to create record file");
            }
            OutputStream stream = this.fileManager.newOutputStream(this.recordFile, true);
            writer = new OutputStreamWriter(stream);
        }
        catch (FileNotFoundException e) {
            logger.e("Records file not found to persist record to", e);
            throw new AmazonClientException("Unable to open record file writer", e);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unexpected error while creating recordsFile writer", e);
        }
        return writer;
    }

    private void tryCloseWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                logger.e("Unable to close writer for records file", e);
            }
        }
    }

    private File deleteAllRecords() {
        File recordsDir = this.fileManager.createDirectory("KinesisRecorder");
        if (!this.recordFile.delete()) {
            logger.e("Failed to delete records file that exceeds the max storage size");
        }
        try {
            this.recordFile = this.fileManager.createFile(new File(recordsDir, "KinesisRecords"));
        }
        catch (IOException e) {
            logger.e("An error occurred while attempting to create the records file", e);
        }
        return this.recordFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private File deleteReadRecords(int lineNumber) {
        block46: {
            File recordsDir;
            block43: {
                IOException e3222;
                PrintWriter writer;
                BufferedReader reader;
                boolean errorsOccurred;
                File tempRecordsFile;
                block42: {
                    recordsDir = this.fileManager.createDirectory("KinesisRecorder");
                    tempRecordsFile = null;
                    try {
                        File tempFile = new File(recordsDir, "KinesisRecords.tmp");
                        if (tempFile.exists() && !tempFile.delete()) {
                            logger.e("Failed to delete previous temp file");
                        }
                        tempRecordsFile = this.fileManager.createFile(tempFile);
                    }
                    catch (IOException e2) {
                        logger.e("An error occurred while attempting to create/open the temporary records file", e2);
                        return this.recordFile;
                    }
                    errorsOccurred = false;
                    if (tempRecordsFile == null || !this.recordFile.exists() || !tempRecordsFile.exists()) break block46;
                    reader = null;
                    writer = null;
                    reader = new BufferedReader(new FileReader(this.recordFile));
                    writer = new PrintWriter(new FileWriter(tempRecordsFile, true));
                    String line = null;
                    int currentLineNumber = 0;
                    while ((line = reader.readLine()) != null) {
                        if (++currentLineNumber <= lineNumber) continue;
                        writer.println(line);
                        writer.flush();
                    }
                    Object var10_13 = null;
                    if (writer != null) {
                        writer.close();
                    }
                    if (reader == null) break block42;
                    try {
                        reader.close();
                    }
                    catch (IOException e3222) {
                        // empty catch block
                    }
                }
                if (errorsOccurred) break block43;
                if (this.recordFile.delete()) {
                    if (!tempRecordsFile.renameTo(this.recordFile)) {
                        logger.e("Failed to rename temp file to records file");
                    }
                    try {
                        this.recordFile = this.fileManager.createFile(new File(recordsDir, "KinesisRecords"));
                    }
                    catch (IOException e3222) {
                        logger.e("An error occurred while attempting to create the recordsFile", e3222);
                    }
                } else {
                    logger.e("Failed to delete previous records file");
                    {
                        break block43;
                        catch (FileNotFoundException e4) {
                            IOException e3222;
                            errorsOccurred = true;
                            logger.e("The records file count not be found", e4);
                            Object var10_14 = null;
                            if (writer != null) {
                                writer.close();
                            }
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException e3222) {
                                    // empty catch block
                                }
                            }
                            if (!errorsOccurred) {
                                if (this.recordFile.delete()) {
                                    if (!tempRecordsFile.renameTo(this.recordFile)) {
                                        logger.e("Failed to rename temp file to records file");
                                    }
                                    try {
                                        this.recordFile = this.fileManager.createFile(new File(recordsDir, "KinesisRecords"));
                                    }
                                    catch (IOException e3222) {
                                        logger.e("An error occurred while attempting to create the recordsFile", e3222);
                                    }
                                } else {
                                    logger.e("Failed to delete previous records file");
                                }
                            }
                            break block43;
                        }
                        catch (IOException e5) {
                            IOException e3222;
                            logger.e("An error occurred while attempting to delete the read records", e5);
                            errorsOccurred = true;
                            Object var10_15 = null;
                            if (writer != null) {
                                writer.close();
                            }
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException e3222) {
                                    // empty catch block
                                }
                            }
                            if (!errorsOccurred) {
                                if (this.recordFile.delete()) {
                                    if (!tempRecordsFile.renameTo(this.recordFile)) {
                                        logger.e("Failed to rename temp file to records file");
                                    }
                                    try {
                                        this.recordFile = this.fileManager.createFile(new File(recordsDir, "KinesisRecords"));
                                    }
                                    catch (IOException e3222) {
                                        logger.e("An error occurred while attempting to create the recordsFile", e3222);
                                    }
                                } else {
                                    logger.e("Failed to delete previous records file");
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        IOException e3222;
                        Object var10_16 = null;
                        if (writer != null) {
                            writer.close();
                        }
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e3222) {
                                // empty catch block
                            }
                        }
                        if (!errorsOccurred) {
                            if (this.recordFile.delete()) {
                                if (!tempRecordsFile.renameTo(this.recordFile)) {
                                    logger.e("Failed to rename temp file to records file");
                                }
                                try {
                                    this.recordFile = this.fileManager.createFile(new File(recordsDir, "KinesisRecords"));
                                }
                                catch (IOException e3222) {
                                    logger.e("An error occurred while attempting to create the recordsFile", e3222);
                                }
                            } else {
                                logger.e("Failed to delete previous records file");
                            }
                        }
                        throw throwable;
                    }
                }
            }
            File tempFile = new File(recordsDir, "KinesisRecords.tmp");
            if (tempFile.exists() && !tempFile.delete()) {
                logger.e("Failed to delete temp file");
            }
        }
        return this.recordFile;
    }

    public RecordStore.RecordIterator iterator() {
        return new RecordStore.RecordIterator(){
            int linesRead = 0;
            String nextBuffer = null;
            BufferedReader reader = null;
            boolean isEndOfFile = false;

            private boolean tryOpenReader() {
                if (this.reader != null) {
                    return true;
                }
                if (!this.isEndOfFile) {
                    InputStreamReader streamReader = null;
                    try {
                        streamReader = new InputStreamReader(FileRecordStore.this.fileManager.newInputStream(FileRecordStore.this.recordFile));
                    }
                    catch (FileNotFoundException e) {
                        logger.e("Could not open the records file", e);
                    }
                    if (streamReader != null) {
                        this.reader = new BufferedReader(streamReader);
                        return true;
                    }
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void tryCloseReader() {
                if (this.reader != null) {
                    try {
                        try {
                            this.reader.close();
                        }
                        catch (IOException ioe) {
                            logger.e("Unable to close reader for records file", ioe);
                            Object var3_2 = null;
                            this.reader = null;
                        }
                        Object var3_1 = null;
                        this.reader = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        this.reader = null;
                        throw throwable;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean hasNext() {
                boolean bl;
                boolean hasNext = false;
                FileRecordStore.this.accessLock.lock();
                try {
                    if (this.nextBuffer != null) {
                        hasNext = true;
                    } else {
                        if (!this.tryOpenReader()) {
                            boolean bl2 = hasNext;
                            Object var5_4 = null;
                            FileRecordStore.this.accessLock.unlock();
                            return bl2;
                        }
                        boolean found = false;
                        while (!found) {
                            try {
                                this.nextBuffer = this.reader.readLine();
                                found = true;
                            }
                            catch (IOException e) {
                                this.nextBuffer = null;
                                found = true;
                            }
                        }
                        if (this.nextBuffer != null) {
                            hasNext = true;
                        } else {
                            this.isEndOfFile = true;
                            this.tryCloseReader();
                        }
                    }
                    bl = hasNext;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    FileRecordStore.this.accessLock.unlock();
                    throw throwable;
                }
                Object var5_5 = null;
                FileRecordStore.this.accessLock.unlock();
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public String next() {
                String string;
                String next = null;
                FileRecordStore.this.accessLock.lock();
                try {
                    if (this.nextBuffer != null) {
                        next = this.nextBuffer;
                        ++this.linesRead;
                        this.nextBuffer = null;
                    } else {
                        if (!this.tryOpenReader()) {
                            String string2 = next;
                            Object var5_5 = null;
                            FileRecordStore.this.accessLock.unlock();
                            return string2;
                        }
                        boolean found = false;
                        while (!found) {
                            try {
                                next = this.reader.readLine();
                                found = true;
                            }
                            catch (IOException e) {
                                next = null;
                                found = true;
                            }
                        }
                        if (next != null) {
                            ++this.linesRead;
                        } else {
                            this.isEndOfFile = true;
                            this.tryCloseReader();
                        }
                    }
                    string = next;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    FileRecordStore.this.accessLock.unlock();
                    throw throwable;
                }
                Object var5_6 = null;
                FileRecordStore.this.accessLock.unlock();
                return string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String peek() {
                FileRecordStore.this.accessLock.lock();
                try {
                    this.hasNext();
                    String string = this.nextBuffer;
                    Object var3_2 = null;
                    FileRecordStore.this.accessLock.unlock();
                    return string;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    FileRecordStore.this.accessLock.unlock();
                    throw throwable;
                }
            }

            public void remove() {
                throw new UnsupportedOperationException("The remove() operation is not supported for this iterator");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeReadRecords() {
                FileRecordStore.this.accessLock.lock();
                try {
                    FileRecordStore.this.deleteReadRecords(this.linesRead);
                    this.resetReader();
                    Object var2_1 = null;
                    FileRecordStore.this.accessLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    FileRecordStore.this.accessLock.unlock();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeAllRecords() {
                FileRecordStore.this.accessLock.lock();
                try {
                    FileRecordStore.this.deleteAllRecords();
                    this.resetReader();
                    Object var2_1 = null;
                    FileRecordStore.this.accessLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    FileRecordStore.this.accessLock.unlock();
                    throw throwable;
                }
            }

            private void resetReader() {
                this.tryCloseReader();
                this.linesRead = 0;
                this.nextBuffer = null;
            }
        };
    }
}

