/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.logging;

import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.logging.LogInitializer;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.logging.appender.DeveloperLogCatAppender;
import com.amazonaws.mobileconnectors.kinesis.kinesisrecorder.internal.logging.appender.LogAppender;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logger {
    public static final String TAG = "KinesisBatcher";
    private static LogLevel globalLevel = LogLevel.WARN;
    private static Map<Class<?>, LogAppender> appenders = new ConcurrentHashMap();
    private static Map<Class<?>, Logger> loggers = new ConcurrentHashMap();
    private LogLevel classLevel = null;
    private Class<?> cls = null;
    private String tag = "KinesisBatcher";
    private static boolean initialized = false;

    public Logger(String tag, Class<?> cls) {
        assert (cls != null);
        this.cls = cls;
        this.tag = tag;
    }

    public synchronized boolean isLoggingEnabled(LogLevel requestedLevel) {
        boolean isEnabled = false;
        if (requestedLevel.compareTo(this.getLogLevel()) >= 0) {
            isEnabled = true;
        }
        return isEnabled;
    }

    synchronized LogLevel getLogLevel() {
        LogLevel level = LogLevel.OFF;
        level = null != this.classLevel ? this.classLevel : Logger.getGlobalLevel();
        return level;
    }

    public static synchronized void setGlobalLevel(LogLevel level) {
        globalLevel = level;
    }

    public static LogLevel getGlobalLevel() {
        return globalLevel;
    }

    public synchronized void setLevel(LogLevel level) {
        this.classLevel = level;
    }

    public static void attachLogAppender(LogAppender appender) {
        Logger.attachAppender(appender);
    }

    public static void detachLogAppender(LogAppender appender) {
        Logger.detachAppender(appender);
    }

    public static Collection<LogAppender> getLogAppenders() {
        return Logger.getAppenders();
    }

    public static Logger getLogger(Class<?> cls) {
        return Logger.getClassLogger(cls);
    }

    static synchronized Logger getClassLogger(Class<?> cls) {
        if (null == cls) {
            cls = Logger.class;
        }
        if (loggers.containsKey(cls)) {
            return loggers.get(cls);
        }
        Logger logger = new Logger(TAG, cls);
        loggers.put(cls, logger);
        return logger;
    }

    public static void attachAppender(LogAppender appender) {
        if (null == appender) {
            return;
        }
        if (!appenders.containsKey(appender.getClass())) {
            appenders.put(appender.getClass(), appender);
        }
    }

    public static void detachAppender(LogAppender appender) {
        if (null == appender) {
            return;
        }
        if (appenders.containsKey(appender.getClass())) {
            appenders.remove(appender.getClass());
        }
    }

    public static Collection<LogAppender> getAppenders() {
        return appenders.values();
    }

    Class<?> getLogClass() {
        return this.cls;
    }

    String getTag() {
        return this.tag;
    }

    public void d(String msg) {
        if (this.isLoggingEnabled(LogLevel.DEBUG)) {
            for (LogAppender appender : Logger.getLogAppenders()) {
                appender.d(this.getTag(), appender.decorateMessage(this.cls, msg));
            }
        }
    }

    public void d(String msg, Throwable tr) {
        if (this.isLoggingEnabled(LogLevel.DEBUG)) {
            for (LogAppender appender : Logger.getLogAppenders()) {
                appender.d(this.getTag(), appender.decorateMessage(this.cls, msg), tr);
            }
        }
    }

    public void devd(String msg) {
        for (LogAppender appender : Logger.getLogAppenders()) {
            appender.devd(this.getTag(), appender.decorateMessage(this.cls, msg));
        }
    }

    public void devd(String msg, Throwable tr) {
        for (LogAppender appender : Logger.getLogAppenders()) {
            appender.devd(this.getTag(), appender.decorateMessage(this.cls, msg), tr);
        }
    }

    public void v(String msg) {
        if (this.isLoggingEnabled(LogLevel.VERBOSE)) {
            for (LogAppender appender : Logger.getLogAppenders()) {
                appender.v(this.getTag(), appender.decorateMessage(this.cls, msg));
            }
        }
    }

    public void v(String msg, Throwable tr) {
        if (this.isLoggingEnabled(LogLevel.VERBOSE)) {
            for (LogAppender appender : Logger.getLogAppenders()) {
                appender.v(this.getTag(), appender.decorateMessage(this.cls, msg), tr);
            }
        }
    }

    public void devv(String msg) {
        for (LogAppender appender : Logger.getLogAppenders()) {
            appender.devv(this.getTag(), appender.decorateMessage(this.cls, msg));
        }
    }

    public void devv(String msg, Throwable tr) {
        for (LogAppender appender : Logger.getLogAppenders()) {
            appender.devv(this.getTag(), appender.decorateMessage(this.cls, msg), tr);
        }
    }

    public void i(String msg) {
        if (this.isLoggingEnabled(LogLevel.INFO)) {
            for (LogAppender appender : Logger.getLogAppenders()) {
                appender.i(this.getTag(), appender.decorateMessage(this.cls, msg));
            }
        }
    }

    public void i(String msg, Throwable tr) {
        if (this.isLoggingEnabled(LogLevel.INFO)) {
            for (LogAppender appender : Logger.getLogAppenders()) {
                appender.i(this.getTag(), appender.decorateMessage(this.cls, msg), tr);
            }
        }
    }

    public void devi(String msg) {
        for (LogAppender appender : Logger.getLogAppenders()) {
            appender.devi(this.getTag(), appender.decorateMessage(this.cls, msg));
        }
    }

    public void devi(String msg, Throwable tr) {
        for (LogAppender appender : Logger.getLogAppenders()) {
            appender.devi(this.getTag(), appender.decorateMessage(this.cls, msg), tr);
        }
    }

    public void w(String msg) {
        if (this.isLoggingEnabled(LogLevel.WARN)) {
            for (LogAppender appender : Logger.getLogAppenders()) {
                appender.w(this.getTag(), appender.decorateMessage(this.cls, msg));
            }
        }
    }

    public void w(Throwable tr) {
        if (this.isLoggingEnabled(LogLevel.WARN)) {
            for (LogAppender appender : Logger.getLogAppenders()) {
                appender.w(this.getTag(), tr);
            }
        }
    }

    public void w(String msg, Throwable tr) {
        if (this.isLoggingEnabled(LogLevel.WARN)) {
            for (LogAppender appender : Logger.getLogAppenders()) {
                appender.w(this.getTag(), appender.decorateMessage(this.cls, msg), tr);
            }
        }
    }

    public void devw(String msg) {
        for (LogAppender appender : Logger.getLogAppenders()) {
            appender.devw(this.getTag(), appender.decorateMessage(this.cls, msg));
        }
    }

    public void devw(Throwable tr) {
        for (LogAppender appender : Logger.getLogAppenders()) {
            appender.devw(this.getTag(), tr);
        }
    }

    public void devw(String msg, Throwable tr) {
        for (LogAppender appender : Logger.getLogAppenders()) {
            appender.devw(this.getTag(), appender.decorateMessage(this.cls, msg), tr);
        }
    }

    public void e(String msg) {
        if (this.isLoggingEnabled(LogLevel.ERROR)) {
            for (LogAppender appender : Logger.getLogAppenders()) {
                appender.e(this.tag, appender.decorateMessage(this.cls, msg));
            }
        }
    }

    public void e(String msg, Throwable tr) {
        if (this.isLoggingEnabled(LogLevel.ERROR)) {
            for (LogAppender appender : Logger.getLogAppenders()) {
                appender.e(this.tag, appender.decorateMessage(this.cls, msg), tr);
            }
        }
    }

    public void deve(String msg) {
        for (LogAppender appender : Logger.getLogAppenders()) {
            appender.deve(this.tag, appender.decorateMessage(this.cls, msg));
        }
    }

    public void deve(String msg, Throwable tr) {
        for (LogAppender appender : Logger.getLogAppenders()) {
            appender.deve(this.tag, appender.decorateMessage(this.cls, msg), tr);
        }
    }

    public static synchronized void tryInitialize() {
        if (!initialized) {
            Logger.tryInitialize(new LogInitializer(){

                public void tryInitialize() {
                    Logger.setGlobalLevel(LogLevel.WARN);
                    Logger.attachAppender(new DeveloperLogCatAppender());
                }
            });
        }
    }

    public static synchronized void tryInitialize(LogInitializer initializer) {
        if (!initialized && initializer != null) {
            initializer.tryInitialize();
            initialized = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogLevel {
        VERBOSE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        OFF;

    }
}

