/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transfermanager;

import com.amazonaws.AmazonClientException;
import com.amazonaws.mobileconnectors.s3.transfermanager.Transfer;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.MultipleFileTransfer;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.TransferStateChangeListener;
import java.util.concurrent.CountDownLatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MultipleFileTransferStateChangeListener
implements TransferStateChangeListener {
    private final CountDownLatch latch;
    private final MultipleFileTransfer<?> multipleFileTransfer;

    public MultipleFileTransferStateChangeListener(CountDownLatch latch, MultipleFileTransfer<?> multipleFileTransfer) {
        this.latch = latch;
        this.multipleFileTransfer = multipleFileTransfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferStateChanged(Transfer upload, Transfer.TransferState state) {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new AmazonClientException("Couldn't wait for all downloads to be queued");
        }
        MultipleFileTransfer<?> multipleFileTransfer = this.multipleFileTransfer;
        synchronized (multipleFileTransfer) {
            if (this.multipleFileTransfer.getState() == state || this.multipleFileTransfer.isDone()) {
                return;
            }
            if (state == Transfer.TransferState.InProgress) {
                this.multipleFileTransfer.setState(state);
            } else if (this.multipleFileTransfer.getMonitor().isDone()) {
                this.multipleFileTransfer.collateFinalState();
            } else {
                this.multipleFileTransfer.setState(Transfer.TransferState.InProgress);
            }
        }
    }
}

