/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transfermanager.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListenerCallbackExecutor;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.mobileconnectors.s3.transfermanager.PauseResult;
import com.amazonaws.mobileconnectors.s3.transfermanager.PauseStatus;
import com.amazonaws.mobileconnectors.s3.transfermanager.PersistableUpload;
import com.amazonaws.mobileconnectors.s3.transfermanager.Transfer;
import com.amazonaws.mobileconnectors.s3.transfermanager.TransferManager;
import com.amazonaws.mobileconnectors.s3.transfermanager.TransferManagerConfiguration;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.TransferManagerUtils;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.TransferMonitor;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.UploadCallable;
import com.amazonaws.mobileconnectors.s3.transfermanager.internal.UploadImpl;
import com.amazonaws.mobileconnectors.s3.transfermanager.model.UploadResult;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadMonitor
implements Callable<UploadResult>,
TransferMonitor {
    private final AmazonS3 s3;
    private final ExecutorService threadPool;
    private final PutObjectRequest putObjectRequest;
    private ScheduledExecutorService timedThreadPool;
    private static final Log log = LogFactory.getLog(UploadMonitor.class);
    private final TransferManagerConfiguration configuration;
    private final ProgressListenerCallbackExecutor progressListenerChainCallbackExecutor;
    private final UploadCallable multipartUploadCallable;
    private final UploadImpl transfer;
    private String uploadId;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private boolean isUploadDone = false;
    private Future<UploadResult> nextFuture;
    private int pollInterval = 5000;

    public synchronized Future<UploadResult> getFuture() {
        return this.nextFuture;
    }

    private synchronized void setNextFuture(Future<UploadResult> nextFuture) {
        this.nextFuture = nextFuture;
    }

    @Override
    public synchronized boolean isDone() {
        return this.isUploadDone;
    }

    private synchronized void markAllDone() {
        this.isUploadDone = true;
    }

    public UploadMonitor(TransferManager manager, UploadImpl transfer, ExecutorService threadPool, UploadCallable multipartUploadCallable, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain) {
        this.s3 = manager.getAmazonS3Client();
        this.configuration = manager.getConfiguration();
        this.multipartUploadCallable = multipartUploadCallable;
        this.threadPool = threadPool;
        this.putObjectRequest = putObjectRequest;
        this.progressListenerChainCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener(progressListenerChain);
        this.transfer = transfer;
        this.setNextFuture(threadPool.submit(this));
    }

    public void setTimedThreadPool(ScheduledExecutorService timedThreadPool) {
        this.timedThreadPool = timedThreadPool;
    }

    @Override
    public UploadResult call() throws Exception {
        try {
            if (this.uploadId == null) {
                return this.upload();
            }
            return this.poll();
        }
        catch (CancellationException e) {
            this.transfer.setState(Transfer.TransferState.Canceled);
            this.fireProgressEvent(16);
            throw new AmazonClientException("Upload canceled");
        }
        catch (Exception e) {
            this.transfer.setState(Transfer.TransferState.Failed);
            this.fireProgressEvent(8);
            throw e;
        }
    }

    private UploadResult poll() throws InterruptedException {
        for (Future<PartETag> f : this.futures) {
            if (f.isDone()) continue;
            this.reschedule();
            return null;
        }
        for (Future<PartETag> f : this.futures) {
            if (!f.isCancelled()) continue;
            throw new CancellationException();
        }
        return this.completeMultipartUpload();
    }

    private UploadResult upload() throws Exception, InterruptedException {
        UploadResult result = this.multipartUploadCallable.call();
        if (result != null) {
            this.uploadComplete();
        } else {
            this.uploadId = this.multipartUploadCallable.getMultipartUploadId();
            this.futures.addAll(this.multipartUploadCallable.getFutures());
            this.reschedule();
        }
        return result;
    }

    private void uploadComplete() {
        this.markAllDone();
        this.transfer.setState(Transfer.TransferState.Completed);
        if (this.multipartUploadCallable.isMultipartUpload()) {
            this.fireProgressEvent(4);
        }
    }

    private void reschedule() {
        this.setNextFuture(this.timedThreadPool.schedule(new Callable<UploadResult>(){

            @Override
            public UploadResult call() throws Exception {
                UploadMonitor.this.setNextFuture(UploadMonitor.this.threadPool.submit(UploadMonitor.this));
                return null;
            }
        }, (long)this.pollInterval, TimeUnit.MILLISECONDS));
    }

    private void fireProgressEvent(int eventType) {
        if (this.progressListenerChainCallbackExecutor == null) {
            return;
        }
        ProgressEvent event = new ProgressEvent(0L);
        event.setEventCode(eventType);
        this.progressListenerChainCallbackExecutor.progressChanged(event);
    }

    private UploadResult completeMultipartUpload() {
        CompleteMultipartUploadResult completeMultipartUploadResult = this.s3.completeMultipartUpload(new CompleteMultipartUploadRequest(this.putObjectRequest.getBucketName(), this.putObjectRequest.getKey(), this.uploadId, this.collectPartETags()));
        this.uploadComplete();
        UploadResult uploadResult = new UploadResult();
        uploadResult.setBucketName(completeMultipartUploadResult.getBucketName());
        uploadResult.setKey(completeMultipartUploadResult.getKey());
        uploadResult.setETag(completeMultipartUploadResult.getETag());
        uploadResult.setVersionId(completeMultipartUploadResult.getVersionId());
        return uploadResult;
    }

    private List<PartETag> collectPartETags() {
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        partETags.addAll(this.multipartUploadCallable.getETags());
        for (Future<PartETag> future : this.futures) {
            try {
                partETags.add(future.get());
            }
            catch (Exception e) {
                throw new AmazonClientException("Unable to upload part: " + e.getCause().getMessage(), e.getCause());
            }
        }
        return partETags;
    }

    PauseResult<PersistableUpload> pause(boolean forceCancel) {
        PersistableUpload persistableUpload = this.multipartUploadCallable.getPersistableUpload();
        if (persistableUpload == null) {
            PauseStatus pauseStatus = TransferManagerUtils.determinePauseStatus(this.transfer.getState(), forceCancel);
            if (forceCancel) {
                this.cancelFutures();
                this.multipartUploadCallable.performAbortMultipartUpload();
            }
            return new PauseResult<PersistableUpload>(pauseStatus);
        }
        this.cancelFutures();
        return new PauseResult<PersistableUpload>(PauseStatus.SUCCESS, persistableUpload);
    }

    private void cancelFutures() {
        this.nextFuture.cancel(true);
        for (Future<PartETag> f : this.futures) {
            f.cancel(true);
        }
        this.multipartUploadCallable.getFutures().clear();
        this.futures.clear();
    }

    void performAbort() {
        this.cancelFutures();
        this.multipartUploadCallable.performAbortMultipartUpload();
    }
}

