/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.services.autoscaling.model.Alarm;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlarmStaxUnmarshaller
implements Unmarshaller<Alarm, StaxUnmarshallerContext> {
    private static AlarmStaxUnmarshaller instance;

    @Override
    public Alarm unmarshall(StaxUnmarshallerContext context) throws Exception {
        Alarm alarm = new Alarm();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return alarm;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("AlarmName", targetDepth)) {
                    alarm.setAlarmName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("AlarmARN", targetDepth)) continue;
                alarm.setAlarmARN(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return alarm;
    }

    public static AlarmStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AlarmStaxUnmarshaller();
        }
        return instance;
    }
}

