/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.services.autoscaling.model.ProcessType;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessTypeStaxUnmarshaller
implements Unmarshaller<ProcessType, StaxUnmarshallerContext> {
    private static ProcessTypeStaxUnmarshaller instance;

    @Override
    public ProcessType unmarshall(StaxUnmarshallerContext context) throws Exception {
        ProcessType processType = new ProcessType();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return processType;
            }
            if (xmlEvent == 2) {
                if (!context.testExpression("ProcessName", targetDepth)) continue;
                processType.setProcessName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return processType;
    }

    public static ProcessTypeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ProcessTypeStaxUnmarshaller();
        }
        return instance;
    }
}

