/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.services.cloudwatch.model.Datapoint;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatapointStaxUnmarshaller
implements Unmarshaller<Datapoint, StaxUnmarshallerContext> {
    private static DatapointStaxUnmarshaller instance;

    @Override
    public Datapoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        Datapoint datapoint = new Datapoint();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return datapoint;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("Timestamp", targetDepth)) {
                    datapoint.setTimestamp(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SampleCount", targetDepth)) {
                    datapoint.setSampleCount(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Average", targetDepth)) {
                    datapoint.setAverage(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Sum", targetDepth)) {
                    datapoint.setSum(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Minimum", targetDepth)) {
                    datapoint.setMinimum(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Maximum", targetDepth)) {
                    datapoint.setMaximum(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Unit", targetDepth)) continue;
                datapoint.setUnit(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return datapoint;
    }

    public static DatapointStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DatapointStaxUnmarshaller();
        }
        return instance;
    }
}

