/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentity.model.IdentityPoolShortDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListIdentityPoolsResult
implements Serializable {
    private ListWithAutoConstructFlag<IdentityPoolShortDescription> identityPools;
    private String nextToken;

    public List<IdentityPoolShortDescription> getIdentityPools() {
        if (this.identityPools == null) {
            this.identityPools = new ListWithAutoConstructFlag();
            this.identityPools.setAutoConstruct(true);
        }
        return this.identityPools;
    }

    public void setIdentityPools(Collection<IdentityPoolShortDescription> identityPools) {
        if (identityPools == null) {
            this.identityPools = null;
            return;
        }
        ListWithAutoConstructFlag identityPoolsCopy = new ListWithAutoConstructFlag(identityPools.size());
        identityPoolsCopy.addAll(identityPools);
        this.identityPools = identityPoolsCopy;
    }

    public ListIdentityPoolsResult withIdentityPools(IdentityPoolShortDescription ... identityPools) {
        if (this.getIdentityPools() == null) {
            this.setIdentityPools(new ArrayList<IdentityPoolShortDescription>(identityPools.length));
        }
        for (IdentityPoolShortDescription value : identityPools) {
            this.getIdentityPools().add(value);
        }
        return this;
    }

    public ListIdentityPoolsResult withIdentityPools(Collection<IdentityPoolShortDescription> identityPools) {
        if (identityPools == null) {
            this.identityPools = null;
        } else {
            ListWithAutoConstructFlag identityPoolsCopy = new ListWithAutoConstructFlag(identityPools.size());
            identityPoolsCopy.addAll(identityPools);
            this.identityPools = identityPoolsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListIdentityPoolsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentityPools() != null) {
            sb.append("IdentityPools: " + this.getIdentityPools() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentityPools() == null ? 0 : this.getIdentityPools().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityPoolsResult)) {
            return false;
        }
        ListIdentityPoolsResult other = (ListIdentityPoolsResult)obj;
        if (other.getIdentityPools() == null ^ this.getIdentityPools() == null) {
            return false;
        }
        if (other.getIdentityPools() != null && !other.getIdentityPools().equals(this.getIdentityPools())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

