/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentity.model.LookupDeveloperIdentityRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupDeveloperIdentityRequestMarshaller
implements Marshaller<Request<LookupDeveloperIdentityRequest>, LookupDeveloperIdentityRequest> {
    @Override
    public Request<LookupDeveloperIdentityRequest> marshall(LookupDeveloperIdentityRequest lookupDeveloperIdentityRequest) {
        if (lookupDeveloperIdentityRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<LookupDeveloperIdentityRequest> request = new DefaultRequest<LookupDeveloperIdentityRequest>(lookupDeveloperIdentityRequest, "AmazonCognitoIdentity");
        String target = "AWSCognitoIdentityService.LookupDeveloperIdentity";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (lookupDeveloperIdentityRequest.getIdentityPoolId() != null) {
                jsonWriter.key("IdentityPoolId").value(lookupDeveloperIdentityRequest.getIdentityPoolId());
            }
            if (lookupDeveloperIdentityRequest.getIdentityId() != null) {
                jsonWriter.key("IdentityId").value(lookupDeveloperIdentityRequest.getIdentityId());
            }
            if (lookupDeveloperIdentityRequest.getDeveloperUserIdentifier() != null) {
                jsonWriter.key("DeveloperUserIdentifier").value(lookupDeveloperIdentityRequest.getDeveloperUserIdentifier());
            }
            if (lookupDeveloperIdentityRequest.getMaxResults() != null) {
                jsonWriter.key("MaxResults").value(lookupDeveloperIdentityRequest.getMaxResults());
            }
            if (lookupDeveloperIdentityRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(lookupDeveloperIdentityRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

