/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.cognitosync.AmazonCognitoSync;
import com.amazonaws.services.cognitosync.model.DeleteDatasetRequest;
import com.amazonaws.services.cognitosync.model.DeleteDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeDatasetRequest;
import com.amazonaws.services.cognitosync.model.DescribeDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageResult;
import com.amazonaws.services.cognitosync.model.GetIdentityPoolConfigurationRequest;
import com.amazonaws.services.cognitosync.model.GetIdentityPoolConfigurationResult;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.services.cognitosync.model.ListDatasetsResult;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.services.cognitosync.model.ListRecordsResult;
import com.amazonaws.services.cognitosync.model.RegisterDeviceRequest;
import com.amazonaws.services.cognitosync.model.RegisterDeviceResult;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationRequest;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationResult;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetRequest;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetResult;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetRequest;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetResult;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.services.cognitosync.model.UpdateRecordsResult;
import com.amazonaws.services.cognitosync.model.transform.DeleteDatasetRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DeleteDatasetResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeDatasetRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeDatasetResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityPoolUsageRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityPoolUsageResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityUsageRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityUsageResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.GetIdentityPoolConfigurationRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.GetIdentityPoolConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.InternalErrorExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.InvalidConfigurationExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListDatasetsRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListDatasetsResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListIdentityPoolUsageRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListIdentityPoolUsageResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListRecordsRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListRecordsResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.NotAuthorizedExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.RegisterDeviceRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.RegisterDeviceResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ResourceConflictExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.SetIdentityPoolConfigurationRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.SetIdentityPoolConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.SubscribeToDatasetRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.SubscribeToDatasetResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.UnsubscribeFromDatasetRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.UnsubscribeFromDatasetResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.UpdateRecordsRequestMarshaller;
import com.amazonaws.services.cognitosync.model.transform.UpdateRecordsResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonCognitoSyncClient
extends AmazonWebServiceClient
implements AmazonCognitoSync {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonCognitoSync.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AmazonCognitoSyncClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonCognitoSyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonCognitoSyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonCognitoSyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AmazonCognitoSyncClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonCognitoSyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonCognitoSyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonCognitoSyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonCognitoSyncClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new ResourceConflictExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new TooManyRequestsExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InternalErrorExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new NotAuthorizedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidConfigurationExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidParameterExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("cognito-sync.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cognitosync/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cognitosync/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRecordsResult updateRecords(UpdateRecordsRequest updateRecordsRequest) {
        UpdateRecordsResult updateRecordsResult;
        ExecutionContext executionContext = this.createExecutionContext(updateRecordsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRecordsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRecordsRequestMarshaller().marshall(updateRecordsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
                Object var7_6 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
                throw throwable;
            }
            UpdateRecordsResultJsonUnmarshaller unmarshaller = new UpdateRecordsResultJsonUnmarshaller();
            JsonResponseHandler<UpdateRecordsResult> responseHandler = new JsonResponseHandler<UpdateRecordsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            updateRecordsResult = (UpdateRecordsResult)response.getAwsResponse();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.endClientExecution(awsRequestMetrics, request, response, true);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response, true);
        return updateRecordsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIdentityUsageResult describeIdentityUsage(DescribeIdentityUsageRequest describeIdentityUsageRequest) {
        DescribeIdentityUsageResult describeIdentityUsageResult;
        ExecutionContext executionContext = this.createExecutionContext(describeIdentityUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeIdentityUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeIdentityUsageRequestMarshaller().marshall(describeIdentityUsageRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
                Object var7_6 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
                throw throwable;
            }
            DescribeIdentityUsageResultJsonUnmarshaller unmarshaller = new DescribeIdentityUsageResultJsonUnmarshaller();
            JsonResponseHandler<DescribeIdentityUsageResult> responseHandler = new JsonResponseHandler<DescribeIdentityUsageResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            describeIdentityUsageResult = (DescribeIdentityUsageResult)response.getAwsResponse();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.endClientExecution(awsRequestMetrics, request, response, true);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response, true);
        return describeIdentityUsageResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityPoolConfigurationResult setIdentityPoolConfiguration(SetIdentityPoolConfigurationRequest setIdentityPoolConfigurationRequest) {
        SetIdentityPoolConfigurationResult setIdentityPoolConfigurationResult;
        ExecutionContext executionContext = this.createExecutionContext(setIdentityPoolConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetIdentityPoolConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetIdentityPoolConfigurationRequestMarshaller().marshall(setIdentityPoolConfigurationRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
                Object var7_6 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
                throw throwable;
            }
            SetIdentityPoolConfigurationResultJsonUnmarshaller unmarshaller = new SetIdentityPoolConfigurationResultJsonUnmarshaller();
            JsonResponseHandler<SetIdentityPoolConfigurationResult> responseHandler = new JsonResponseHandler<SetIdentityPoolConfigurationResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            setIdentityPoolConfigurationResult = (SetIdentityPoolConfigurationResult)response.getAwsResponse();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.endClientExecution(awsRequestMetrics, request, response, true);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response, true);
        return setIdentityPoolConfigurationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityPoolConfigurationResult getIdentityPoolConfiguration(GetIdentityPoolConfigurationRequest getIdentityPoolConfigurationRequest) {
        GetIdentityPoolConfigurationResult getIdentityPoolConfigurationResult;
        ExecutionContext executionContext = this.createExecutionContext(getIdentityPoolConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIdentityPoolConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIdentityPoolConfigurationRequestMarshaller().marshall(getIdentityPoolConfigurationRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
                Object var7_6 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
                throw throwable;
            }
            GetIdentityPoolConfigurationResultJsonUnmarshaller unmarshaller = new GetIdentityPoolConfigurationResultJsonUnmarshaller();
            JsonResponseHandler<GetIdentityPoolConfigurationResult> responseHandler = new JsonResponseHandler<GetIdentityPoolConfigurationResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            getIdentityPoolConfigurationResult = (GetIdentityPoolConfigurationResult)response.getAwsResponse();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.endClientExecution(awsRequestMetrics, request, response, true);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response, true);
        return getIdentityPoolConfigurationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnsubscribeFromDatasetResult unsubscribeFromDataset(UnsubscribeFromDatasetRequest unsubscribeFromDatasetRequest) {
        UnsubscribeFromDatasetResult unsubscribeFromDatasetResult;
        ExecutionContext executionContext = this.createExecutionContext(unsubscribeFromDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UnsubscribeFromDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UnsubscribeFromDatasetRequestMarshaller().marshall(unsubscribeFromDatasetRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
                Object var7_6 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
                throw throwable;
            }
            UnsubscribeFromDatasetResultJsonUnmarshaller unmarshaller = new UnsubscribeFromDatasetResultJsonUnmarshaller();
            JsonResponseHandler<UnsubscribeFromDatasetResult> responseHandler = new JsonResponseHandler<UnsubscribeFromDatasetResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            unsubscribeFromDatasetResult = (UnsubscribeFromDatasetResult)response.getAwsResponse();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.endClientExecution(awsRequestMetrics, request, response, true);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response, true);
        return unsubscribeFromDatasetResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscribeToDatasetResult subscribeToDataset(SubscribeToDatasetRequest subscribeToDatasetRequest) {
        SubscribeToDatasetResult subscribeToDatasetResult;
        ExecutionContext executionContext = this.createExecutionContext(subscribeToDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SubscribeToDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SubscribeToDatasetRequestMarshaller().marshall(subscribeToDatasetRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
                Object var7_6 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
                throw throwable;
            }
            SubscribeToDatasetResultJsonUnmarshaller unmarshaller = new SubscribeToDatasetResultJsonUnmarshaller();
            JsonResponseHandler<SubscribeToDatasetResult> responseHandler = new JsonResponseHandler<SubscribeToDatasetResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            subscribeToDatasetResult = (SubscribeToDatasetResult)response.getAwsResponse();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.endClientExecution(awsRequestMetrics, request, response, true);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response, true);
        return subscribeToDatasetResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIdentityPoolUsageResult describeIdentityPoolUsage(DescribeIdentityPoolUsageRequest describeIdentityPoolUsageRequest) {
        DescribeIdentityPoolUsageResult describeIdentityPoolUsageResult;
        ExecutionContext executionContext = this.createExecutionContext(describeIdentityPoolUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeIdentityPoolUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeIdentityPoolUsageRequestMarshaller().marshall(describeIdentityPoolUsageRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
                Object var7_6 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
                throw throwable;
            }
            DescribeIdentityPoolUsageResultJsonUnmarshaller unmarshaller = new DescribeIdentityPoolUsageResultJsonUnmarshaller();
            JsonResponseHandler<DescribeIdentityPoolUsageResult> responseHandler = new JsonResponseHandler<DescribeIdentityPoolUsageResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            describeIdentityPoolUsageResult = (DescribeIdentityPoolUsageResult)response.getAwsResponse();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.endClientExecution(awsRequestMetrics, request, response, true);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response, true);
        return describeIdentityPoolUsageResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest listDatasetsRequest) {
        ListDatasetsResult listDatasetsResult;
        ExecutionContext executionContext = this.createExecutionContext(listDatasetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDatasetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDatasetsRequestMarshaller().marshall(listDatasetsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
                Object var7_6 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
                throw throwable;
            }
            ListDatasetsResultJsonUnmarshaller unmarshaller = new ListDatasetsResultJsonUnmarshaller();
            JsonResponseHandler<ListDatasetsResult> responseHandler = new JsonResponseHandler<ListDatasetsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            listDatasetsResult = (ListDatasetsResult)response.getAwsResponse();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.endClientExecution(awsRequestMetrics, request, response, true);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response, true);
        return listDatasetsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentityPoolUsageResult listIdentityPoolUsage(ListIdentityPoolUsageRequest listIdentityPoolUsageRequest) {
        ListIdentityPoolUsageResult listIdentityPoolUsageResult;
        ExecutionContext executionContext = this.createExecutionContext(listIdentityPoolUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListIdentityPoolUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListIdentityPoolUsageRequestMarshaller().marshall(listIdentityPoolUsageRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
                Object var7_6 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
                throw throwable;
            }
            ListIdentityPoolUsageResultJsonUnmarshaller unmarshaller = new ListIdentityPoolUsageResultJsonUnmarshaller();
            JsonResponseHandler<ListIdentityPoolUsageResult> responseHandler = new JsonResponseHandler<ListIdentityPoolUsageResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            listIdentityPoolUsageResult = (ListIdentityPoolUsageResult)response.getAwsResponse();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.endClientExecution(awsRequestMetrics, request, response, true);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response, true);
        return listIdentityPoolUsageResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecordsResult listRecords(ListRecordsRequest listRecordsRequest) {
        ListRecordsResult listRecordsResult;
        ExecutionContext executionContext = this.createExecutionContext(listRecordsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecordsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecordsRequestMarshaller().marshall(listRecordsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
                Object var7_6 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
                throw throwable;
            }
            ListRecordsResultJsonUnmarshaller unmarshaller = new ListRecordsResultJsonUnmarshaller();
            JsonResponseHandler<ListRecordsResult> responseHandler = new JsonResponseHandler<ListRecordsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            listRecordsResult = (ListRecordsResult)response.getAwsResponse();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.endClientExecution(awsRequestMetrics, request, response, true);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response, true);
        return listRecordsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDatasetResult describeDataset(DescribeDatasetRequest describeDatasetRequest) {
        DescribeDatasetResult describeDatasetResult;
        ExecutionContext executionContext = this.createExecutionContext(describeDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDatasetRequestMarshaller().marshall(describeDatasetRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
                Object var7_6 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
                throw throwable;
            }
            DescribeDatasetResultJsonUnmarshaller unmarshaller = new DescribeDatasetResultJsonUnmarshaller();
            JsonResponseHandler<DescribeDatasetResult> responseHandler = new JsonResponseHandler<DescribeDatasetResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            describeDatasetResult = (DescribeDatasetResult)response.getAwsResponse();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.endClientExecution(awsRequestMetrics, request, response, true);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response, true);
        return describeDatasetResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDatasetResult deleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        DeleteDatasetResult deleteDatasetResult;
        ExecutionContext executionContext = this.createExecutionContext(deleteDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDatasetRequestMarshaller().marshall(deleteDatasetRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
                Object var7_6 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
                throw throwable;
            }
            DeleteDatasetResultJsonUnmarshaller unmarshaller = new DeleteDatasetResultJsonUnmarshaller();
            JsonResponseHandler<DeleteDatasetResult> responseHandler = new JsonResponseHandler<DeleteDatasetResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            deleteDatasetResult = (DeleteDatasetResult)response.getAwsResponse();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.endClientExecution(awsRequestMetrics, request, response, true);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response, true);
        return deleteDatasetResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterDeviceResult registerDevice(RegisterDeviceRequest registerDeviceRequest) {
        RegisterDeviceResult registerDeviceResult;
        ExecutionContext executionContext = this.createExecutionContext(registerDeviceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterDeviceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterDeviceRequestMarshaller().marshall(registerDeviceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
                Object var7_6 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
                throw throwable;
            }
            RegisterDeviceResultJsonUnmarshaller unmarshaller = new RegisterDeviceResultJsonUnmarshaller();
            JsonResponseHandler<RegisterDeviceResult> responseHandler = new JsonResponseHandler<RegisterDeviceResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            registerDeviceResult = (RegisterDeviceResult)response.getAwsResponse();
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.endClientExecution(awsRequestMetrics, request, response, true);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response, true);
        return registerDeviceResult;
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    @Override
    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
            Object var7_6 = null;
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
            throw throwable;
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        return result;
    }
}

