/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitosync.model.Record;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateRecordsResult
implements Serializable {
    private ListWithAutoConstructFlag<Record> records;

    public List<Record> getRecords() {
        if (this.records == null) {
            this.records = new ListWithAutoConstructFlag();
            this.records.setAutoConstruct(true);
        }
        return this.records;
    }

    public void setRecords(Collection<Record> records) {
        if (records == null) {
            this.records = null;
            return;
        }
        ListWithAutoConstructFlag recordsCopy = new ListWithAutoConstructFlag(records.size());
        recordsCopy.addAll(records);
        this.records = recordsCopy;
    }

    public UpdateRecordsResult withRecords(Record ... records) {
        if (this.getRecords() == null) {
            this.setRecords(new ArrayList<Record>(records.length));
        }
        for (Record value : records) {
            this.getRecords().add(value);
        }
        return this;
    }

    public UpdateRecordsResult withRecords(Collection<Record> records) {
        if (records == null) {
            this.records = null;
        } else {
            ListWithAutoConstructFlag recordsCopy = new ListWithAutoConstructFlag(records.size());
            recordsCopy.addAll(records);
            this.records = recordsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecords() != null) {
            sb.append("Records: " + this.getRecords());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecords() == null ? 0 : this.getRecords().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecordsResult)) {
            return false;
        }
        UpdateRecordsResult other = (UpdateRecordsResult)obj;
        if (other.getRecords() == null ^ this.getRecords() == null) {
            return false;
        }
        return other.getRecords() == null || other.getRecords().equals(this.getRecords());
    }
}

