/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitosync.model.PushSync;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetIdentityPoolConfigurationRequestMarshaller
implements Marshaller<Request<SetIdentityPoolConfigurationRequest>, SetIdentityPoolConfigurationRequest> {
    @Override
    public Request<SetIdentityPoolConfigurationRequest> marshall(SetIdentityPoolConfigurationRequest setIdentityPoolConfigurationRequest) {
        if (setIdentityPoolConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetIdentityPoolConfigurationRequest> request = new DefaultRequest<SetIdentityPoolConfigurationRequest>(setIdentityPoolConfigurationRequest, "AmazonCognitoSync");
        String target = "AWSCognitoSyncService.SetIdentityPoolConfiguration";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/configuration";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", setIdentityPoolConfigurationRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString(setIdentityPoolConfigurationRequest.getIdentityPoolId()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            PushSync pushSync = setIdentityPoolConfigurationRequest.getPushSync();
            if (pushSync != null) {
                jsonWriter.key("PushSync");
                jsonWriter.object();
                ListWithAutoConstructFlag applicationArnsList = (ListWithAutoConstructFlag)pushSync.getApplicationArns();
                if (!(applicationArnsList == null || applicationArnsList.isAutoConstruct() && applicationArnsList.isEmpty())) {
                    jsonWriter.key("ApplicationArns");
                    jsonWriter.array();
                    for (String applicationArnsListValue : applicationArnsList) {
                        if (applicationArnsListValue == null) continue;
                        jsonWriter.value(applicationArnsListValue);
                    }
                    jsonWriter.endArray();
                }
                if (pushSync.getRoleArn() != null) {
                    jsonWriter.key("RoleArn").value(pushSync.getRoleArn());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

