/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscribeToDatasetRequestMarshaller
implements Marshaller<Request<SubscribeToDatasetRequest>, SubscribeToDatasetRequest> {
    @Override
    public Request<SubscribeToDatasetRequest> marshall(SubscribeToDatasetRequest subscribeToDatasetRequest) {
        if (subscribeToDatasetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SubscribeToDatasetRequest> request = new DefaultRequest<SubscribeToDatasetRequest>(subscribeToDatasetRequest, "AmazonCognitoSync");
        String target = "AWSCognitoSyncService.SubscribeToDataset";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", subscribeToDatasetRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString(subscribeToDatasetRequest.getIdentityPoolId()));
        uriResourcePath = uriResourcePath.replace("{IdentityId}", subscribeToDatasetRequest.getIdentityId() == null ? "" : StringUtils.fromString(subscribeToDatasetRequest.getIdentityId()));
        uriResourcePath = uriResourcePath.replace("{DatasetName}", subscribeToDatasetRequest.getDatasetName() == null ? "" : StringUtils.fromString(subscribeToDatasetRequest.getDatasetName()));
        uriResourcePath = uriResourcePath.replace("{DeviceId}", subscribeToDatasetRequest.getDeviceId() == null ? "" : StringUtils.fromString(subscribeToDatasetRequest.getDeviceId()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

