/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsubscribeFromDatasetRequestMarshaller
implements Marshaller<Request<UnsubscribeFromDatasetRequest>, UnsubscribeFromDatasetRequest> {
    @Override
    public Request<UnsubscribeFromDatasetRequest> marshall(UnsubscribeFromDatasetRequest unsubscribeFromDatasetRequest) {
        if (unsubscribeFromDatasetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UnsubscribeFromDatasetRequest> request = new DefaultRequest<UnsubscribeFromDatasetRequest>(unsubscribeFromDatasetRequest, "AmazonCognitoSync");
        String target = "AWSCognitoSyncService.UnsubscribeFromDataset";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", unsubscribeFromDatasetRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString(unsubscribeFromDatasetRequest.getIdentityPoolId()));
        uriResourcePath = uriResourcePath.replace("{IdentityId}", unsubscribeFromDatasetRequest.getIdentityId() == null ? "" : StringUtils.fromString(unsubscribeFromDatasetRequest.getIdentityId()));
        uriResourcePath = uriResourcePath.replace("{DatasetName}", unsubscribeFromDatasetRequest.getDatasetName() == null ? "" : StringUtils.fromString(unsubscribeFromDatasetRequest.getDatasetName()));
        uriResourcePath = uriResourcePath.replace("{DeviceId}", unsubscribeFromDatasetRequest.getDeviceId() == null ? "" : StringUtils.fromString(unsubscribeFromDatasetRequest.getDeviceId()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

