/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchGetItemRequestMarshaller
implements Marshaller<Request<BatchGetItemRequest>, BatchGetItemRequest> {
    @Override
    public Request<BatchGetItemRequest> marshall(BatchGetItemRequest batchGetItemRequest) {
        if (batchGetItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchGetItemRequest> request = new DefaultRequest<BatchGetItemRequest>(batchGetItemRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.BatchGetItem";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (batchGetItemRequest.getRequestItems() != null) {
                jsonWriter.key("RequestItems");
                jsonWriter.object();
                for (Map.Entry<String, KeysAndAttributes> requestItemsListValue : batchGetItemRequest.getRequestItems().entrySet()) {
                    ListWithAutoConstructFlag attributesToGetList;
                    if (requestItemsListValue.getValue() == null) continue;
                    jsonWriter.key(requestItemsListValue.getKey());
                    jsonWriter.object();
                    ListWithAutoConstructFlag keysList = (ListWithAutoConstructFlag)requestItemsListValue.getValue().getKeys();
                    if (!(keysList == null || keysList.isAutoConstruct() && keysList.isEmpty())) {
                        jsonWriter.key("Keys");
                        jsonWriter.array();
                        for (Map keysListValue : keysList) {
                            if (keysListValue == null) continue;
                            jsonWriter.object();
                            for (Map.Entry memberListValue : keysListValue.entrySet()) {
                                if (memberListValue.getValue() == null) continue;
                                jsonWriter.key((String)memberListValue.getKey());
                                AttributeValueJsonMarshaller.getInstance().marshall((AttributeValue)memberListValue.getValue(), jsonWriter);
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (!((attributesToGetList = (ListWithAutoConstructFlag)requestItemsListValue.getValue().getAttributesToGet()) == null || attributesToGetList.isAutoConstruct() && attributesToGetList.isEmpty())) {
                        jsonWriter.key("AttributesToGet");
                        jsonWriter.array();
                        for (String string : attributesToGetList) {
                            if (string == null) continue;
                            jsonWriter.value(string);
                        }
                        jsonWriter.endArray();
                    }
                    if (requestItemsListValue.getValue().isConsistentRead() != null) {
                        jsonWriter.key("ConsistentRead").value(requestItemsListValue.getValue().isConsistentRead());
                    }
                    if (requestItemsListValue.getValue().getProjectionExpression() != null) {
                        jsonWriter.key("ProjectionExpression").value(requestItemsListValue.getValue().getProjectionExpression());
                    }
                    if (requestItemsListValue.getValue().getExpressionAttributeNames() != null) {
                        jsonWriter.key("ExpressionAttributeNames");
                        jsonWriter.object();
                        for (Map.Entry entry : requestItemsListValue.getValue().getExpressionAttributeNames().entrySet()) {
                            if (entry.getValue() == null) continue;
                            jsonWriter.key((String)entry.getKey());
                            jsonWriter.value(entry.getValue());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (batchGetItemRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value(batchGetItemRequest.getReturnConsumedCapacity());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

