/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.AccountAttribute;
import com.amazonaws.services.ec2.model.transform.AccountAttributeValueStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountAttributeStaxUnmarshaller
implements Unmarshaller<AccountAttribute, StaxUnmarshallerContext> {
    private static AccountAttributeStaxUnmarshaller instance;

    @Override
    public AccountAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        AccountAttribute accountAttribute = new AccountAttribute();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return accountAttribute;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("attributeName", targetDepth)) {
                    accountAttribute.setAttributeName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("attributeValueSet/item", targetDepth)) continue;
                accountAttribute.getAttributeValues().add(AccountAttributeValueStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return accountAttribute;
    }

    public static AccountAttributeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AccountAttributeStaxUnmarshaller();
        }
        return instance;
    }
}

