/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.DhcpOptions;
import com.amazonaws.services.ec2.model.transform.DhcpConfigurationStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DhcpOptionsStaxUnmarshaller
implements Unmarshaller<DhcpOptions, StaxUnmarshallerContext> {
    private static DhcpOptionsStaxUnmarshaller instance;

    @Override
    public DhcpOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        DhcpOptions dhcpOptions = new DhcpOptions();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return dhcpOptions;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("dhcpOptionsId", targetDepth)) {
                    dhcpOptions.setDhcpOptionsId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("dhcpConfigurationSet/item", targetDepth)) {
                    dhcpOptions.getDhcpConfigurations().add(DhcpConfigurationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("tagSet/item", targetDepth)) continue;
                dhcpOptions.getTags().add(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return dhcpOptions;
    }

    public static DhcpOptionsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DhcpOptionsStaxUnmarshaller();
        }
        return instance;
    }
}

