/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.DiskImageDescription;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskImageDescriptionStaxUnmarshaller
implements Unmarshaller<DiskImageDescription, StaxUnmarshallerContext> {
    private static DiskImageDescriptionStaxUnmarshaller instance;

    @Override
    public DiskImageDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        DiskImageDescription diskImageDescription = new DiskImageDescription();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return diskImageDescription;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("format", targetDepth)) {
                    diskImageDescription.setFormat(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("size", targetDepth)) {
                    diskImageDescription.setSize(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("importManifestUrl", targetDepth)) {
                    diskImageDescription.setImportManifestUrl(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("checksum", targetDepth)) continue;
                diskImageDescription.setChecksum(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return diskImageDescription;
    }

    public static DiskImageDescriptionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DiskImageDescriptionStaxUnmarshaller();
        }
        return instance;
    }
}

