/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EbsBlockDeviceStaxUnmarshaller
implements Unmarshaller<EbsBlockDevice, StaxUnmarshallerContext> {
    private static EbsBlockDeviceStaxUnmarshaller instance;

    @Override
    public EbsBlockDevice unmarshall(StaxUnmarshallerContext context) throws Exception {
        EbsBlockDevice ebsBlockDevice = new EbsBlockDevice();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return ebsBlockDevice;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("snapshotId", targetDepth)) {
                    ebsBlockDevice.setSnapshotId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("volumeSize", targetDepth)) {
                    ebsBlockDevice.setVolumeSize(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("deleteOnTermination", targetDepth)) {
                    ebsBlockDevice.setDeleteOnTermination(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("volumeType", targetDepth)) {
                    ebsBlockDevice.setVolumeType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("iops", targetDepth)) {
                    ebsBlockDevice.setIops(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("encrypted", targetDepth)) continue;
                ebsBlockDevice.setEncrypted(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return ebsBlockDevice;
    }

    public static EbsBlockDeviceStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EbsBlockDeviceStaxUnmarshaller();
        }
        return instance;
    }
}

