/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.KeyPairInfo;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyPairInfoStaxUnmarshaller
implements Unmarshaller<KeyPairInfo, StaxUnmarshallerContext> {
    private static KeyPairInfoStaxUnmarshaller instance;

    @Override
    public KeyPairInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        KeyPairInfo keyPairInfo = new KeyPairInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return keyPairInfo;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("keyName", targetDepth)) {
                    keyPairInfo.setKeyName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("keyFingerprint", targetDepth)) continue;
                keyPairInfo.setKeyFingerprint(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return keyPairInfo;
    }

    public static KeyPairInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new KeyPairInfoStaxUnmarshaller();
        }
        return instance;
    }
}

