/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.NetworkAcl;
import com.amazonaws.services.ec2.model.transform.NetworkAclAssociationStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.NetworkAclEntryStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkAclStaxUnmarshaller
implements Unmarshaller<NetworkAcl, StaxUnmarshallerContext> {
    private static NetworkAclStaxUnmarshaller instance;

    @Override
    public NetworkAcl unmarshall(StaxUnmarshallerContext context) throws Exception {
        NetworkAcl networkAcl = new NetworkAcl();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return networkAcl;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("networkAclId", targetDepth)) {
                    networkAcl.setNetworkAclId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("vpcId", targetDepth)) {
                    networkAcl.setVpcId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("default", targetDepth)) {
                    networkAcl.setIsDefault(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("entrySet/item", targetDepth)) {
                    networkAcl.getEntries().add(NetworkAclEntryStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("associationSet/item", targetDepth)) {
                    networkAcl.getAssociations().add(NetworkAclAssociationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("tagSet/item", targetDepth)) continue;
                networkAcl.getTags().add(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return networkAcl;
    }

    public static NetworkAclStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new NetworkAclStaxUnmarshaller();
        }
        return instance;
    }
}

