/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.PlacementGroup;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlacementGroupStaxUnmarshaller
implements Unmarshaller<PlacementGroup, StaxUnmarshallerContext> {
    private static PlacementGroupStaxUnmarshaller instance;

    @Override
    public PlacementGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        PlacementGroup placementGroup = new PlacementGroup();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return placementGroup;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("groupName", targetDepth)) {
                    placementGroup.setGroupName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("strategy", targetDepth)) {
                    placementGroup.setStrategy(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("state", targetDepth)) continue;
                placementGroup.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return placementGroup;
    }

    public static PlacementGroupStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PlacementGroupStaxUnmarshaller();
        }
        return instance;
    }
}

