/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.ProductCode;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductCodeStaxUnmarshaller
implements Unmarshaller<ProductCode, StaxUnmarshallerContext> {
    private static ProductCodeStaxUnmarshaller instance;

    @Override
    public ProductCode unmarshall(StaxUnmarshallerContext context) throws Exception {
        ProductCode productCode = new ProductCode();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return productCode;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("productCode", targetDepth)) {
                    productCode.setProductCodeId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("type", targetDepth)) continue;
                productCode.setProductCodeType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return productCode;
    }

    public static ProductCodeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ProductCodeStaxUnmarshaller();
        }
        return instance;
    }
}

