/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.SpotPrice;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpotPriceStaxUnmarshaller
implements Unmarshaller<SpotPrice, StaxUnmarshallerContext> {
    private static SpotPriceStaxUnmarshaller instance;

    @Override
    public SpotPrice unmarshall(StaxUnmarshallerContext context) throws Exception {
        SpotPrice spotPrice = new SpotPrice();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return spotPrice;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("instanceType", targetDepth)) {
                    spotPrice.setInstanceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("productDescription", targetDepth)) {
                    spotPrice.setProductDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("spotPrice", targetDepth)) {
                    spotPrice.setSpotPrice(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("timestamp", targetDepth)) {
                    spotPrice.setTimestamp(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("availabilityZone", targetDepth)) continue;
                spotPrice.setAvailabilityZone(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return spotPrice;
    }

    public static SpotPriceStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SpotPriceStaxUnmarshaller();
        }
        return instance;
    }
}

