/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Subnet;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubnetStaxUnmarshaller
implements Unmarshaller<Subnet, StaxUnmarshallerContext> {
    private static SubnetStaxUnmarshaller instance;

    @Override
    public Subnet unmarshall(StaxUnmarshallerContext context) throws Exception {
        Subnet subnet = new Subnet();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return subnet;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("subnetId", targetDepth)) {
                    subnet.setSubnetId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    subnet.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("vpcId", targetDepth)) {
                    subnet.setVpcId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("cidrBlock", targetDepth)) {
                    subnet.setCidrBlock(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availableIpAddressCount", targetDepth)) {
                    subnet.setAvailableIpAddressCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availabilityZone", targetDepth)) {
                    subnet.setAvailabilityZone(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("defaultForAz", targetDepth)) {
                    subnet.setDefaultForAz(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("mapPublicIpOnLaunch", targetDepth)) {
                    subnet.setMapPublicIpOnLaunch(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("tagSet/item", targetDepth)) continue;
                subnet.getTags().add(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return subnet;
    }

    public static SubnetStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SubnetStaxUnmarshaller();
        }
        return instance;
    }
}

