/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.services.elasticloadbalancing.model.Listener;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerStaxUnmarshaller
implements Unmarshaller<Listener, StaxUnmarshallerContext> {
    private static ListenerStaxUnmarshaller instance;

    @Override
    public Listener unmarshall(StaxUnmarshallerContext context) throws Exception {
        Listener listener = new Listener();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return listener;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("Protocol", targetDepth)) {
                    listener.setProtocol(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LoadBalancerPort", targetDepth)) {
                    listener.setLoadBalancerPort(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstanceProtocol", targetDepth)) {
                    listener.setInstanceProtocol(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstancePort", targetDepth)) {
                    listener.setInstancePort(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SSLCertificateId", targetDepth)) continue;
                listener.setSSLCertificateId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return listener;
    }

    public static ListenerStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ListenerStaxUnmarshaller();
        }
        return instance;
    }
}

