/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes;
import com.amazonaws.services.elasticloadbalancing.model.transform.AccessLogStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.ConnectionDrainingStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CrossZoneLoadBalancingStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancerAttributesStaxUnmarshaller
implements Unmarshaller<LoadBalancerAttributes, StaxUnmarshallerContext> {
    private static LoadBalancerAttributesStaxUnmarshaller instance;

    @Override
    public LoadBalancerAttributes unmarshall(StaxUnmarshallerContext context) throws Exception {
        LoadBalancerAttributes loadBalancerAttributes = new LoadBalancerAttributes();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return loadBalancerAttributes;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("CrossZoneLoadBalancing", targetDepth)) {
                    loadBalancerAttributes.setCrossZoneLoadBalancing(CrossZoneLoadBalancingStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AccessLog", targetDepth)) {
                    loadBalancerAttributes.setAccessLog(AccessLogStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ConnectionDraining", targetDepth)) continue;
                loadBalancerAttributes.setConnectionDraining(ConnectionDrainingStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return loadBalancerAttributes;
    }

    public static LoadBalancerAttributesStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LoadBalancerAttributesStaxUnmarshaller();
        }
        return instance;
    }
}

