/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.services.elasticloadbalancing.model.Policies;
import com.amazonaws.services.elasticloadbalancing.model.transform.AppCookieStickinessPolicyStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.LBCookieStickinessPolicyStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoliciesStaxUnmarshaller
implements Unmarshaller<Policies, StaxUnmarshallerContext> {
    private static PoliciesStaxUnmarshaller instance;

    @Override
    public Policies unmarshall(StaxUnmarshallerContext context) throws Exception {
        Policies policies = new Policies();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return policies;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("AppCookieStickinessPolicies/member", targetDepth)) {
                    policies.getAppCookieStickinessPolicies().add(AppCookieStickinessPolicyStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LBCookieStickinessPolicies/member", targetDepth)) {
                    policies.getLBCookieStickinessPolicies().add(LBCookieStickinessPolicyStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OtherPolicies/member", targetDepth)) continue;
                policies.getOtherPolicies().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return policies;
    }

    public static PoliciesStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PoliciesStaxUnmarshaller();
        }
        return instance;
    }
}

