/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.services.elasticloadbalancing.model.PolicyDescription;
import com.amazonaws.services.elasticloadbalancing.model.transform.PolicyAttributeDescriptionStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyDescriptionStaxUnmarshaller
implements Unmarshaller<PolicyDescription, StaxUnmarshallerContext> {
    private static PolicyDescriptionStaxUnmarshaller instance;

    @Override
    public PolicyDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        PolicyDescription policyDescription = new PolicyDescription();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return policyDescription;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("PolicyName", targetDepth)) {
                    policyDescription.setPolicyName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PolicyTypeName", targetDepth)) {
                    policyDescription.setPolicyTypeName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("PolicyAttributeDescriptions/member", targetDepth)) continue;
                policyDescription.getPolicyAttributeDescriptions().add(PolicyAttributeDescriptionStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return policyDescription;
    }

    public static PolicyDescriptionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PolicyDescriptionStaxUnmarshaller();
        }
        return instance;
    }
}

