/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.services.elasticloadbalancing.model.SourceSecurityGroup;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceSecurityGroupStaxUnmarshaller
implements Unmarshaller<SourceSecurityGroup, StaxUnmarshallerContext> {
    private static SourceSecurityGroupStaxUnmarshaller instance;

    @Override
    public SourceSecurityGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        SourceSecurityGroup sourceSecurityGroup = new SourceSecurityGroup();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            int xmlEvent;
            if ((xmlEvent = context.nextEvent()) == 1) {
                return sourceSecurityGroup;
            }
            if (xmlEvent == 2) {
                if (context.testExpression("OwnerAlias", targetDepth)) {
                    sourceSecurityGroup.setOwnerAlias(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("GroupName", targetDepth)) continue;
                sourceSecurityGroup.setGroupName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
        }
        return sourceSecurityGroup;
    }

    public static SourceSecurityGroupStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SourceSecurityGroupStaxUnmarshaller();
        }
        return instance;
    }
}

