/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mobileanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.mobileanalytics.model.Event;
import com.amazonaws.services.mobileanalytics.model.PutEventsRequest;
import com.amazonaws.services.mobileanalytics.model.Session;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutEventsRequestMarshaller
implements Marshaller<Request<PutEventsRequest>, PutEventsRequest> {
    @Override
    public Request<PutEventsRequest> marshall(PutEventsRequest putEventsRequest) {
        if (putEventsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutEventsRequest> request = new DefaultRequest<PutEventsRequest>(putEventsRequest, "AmazonMobileAnalytics");
        String target = "AmazonMobileAnalytics.PutEvents";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        if (putEventsRequest.getClientContext() != null) {
            request.addHeader("x-amz-Client-Context", StringUtils.fromString(putEventsRequest.getClientContext()));
        }
        if (putEventsRequest.getClientContextEncoding() != null) {
            request.addHeader("x-amz-Client-Context-Encoding", StringUtils.fromString(putEventsRequest.getClientContextEncoding()));
        }
        String uriResourcePath = "/2014-06-05/events";
        if ((uriResourcePath = uriResourcePath.replaceAll("//", "/")).contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag eventsList = (ListWithAutoConstructFlag)putEventsRequest.getEvents();
            if (!(eventsList == null || eventsList.isAutoConstruct() && eventsList.isEmpty())) {
                jsonWriter.key("events");
                jsonWriter.array();
                for (Event eventsListValue : eventsList) {
                    Session session;
                    if (eventsListValue == null) continue;
                    jsonWriter.object();
                    if (eventsListValue.getEventType() != null) {
                        jsonWriter.key("eventType").value(eventsListValue.getEventType());
                    }
                    if (eventsListValue.getTimestamp() != null) {
                        jsonWriter.key("timestamp").value(eventsListValue.getTimestamp());
                    }
                    if ((session = eventsListValue.getSession()) != null) {
                        jsonWriter.key("session");
                        jsonWriter.object();
                        if (session.getId() != null) {
                            jsonWriter.key("id").value(session.getId());
                        }
                        if (session.getDuration() != null) {
                            jsonWriter.key("duration").value(session.getDuration());
                        }
                        if (session.getStartTimestamp() != null) {
                            jsonWriter.key("startTimestamp").value(session.getStartTimestamp());
                        }
                        if (session.getStopTimestamp() != null) {
                            jsonWriter.key("stopTimestamp").value(session.getStopTimestamp());
                        }
                        jsonWriter.endObject();
                    }
                    if (eventsListValue.getVersion() != null) {
                        jsonWriter.key("version").value(eventsListValue.getVersion());
                    }
                    if (eventsListValue.getAttributes() != null) {
                        jsonWriter.key("attributes");
                        jsonWriter.object();
                        for (Map.Entry<String, Object> entry : eventsListValue.getAttributes().entrySet()) {
                            if (entry.getValue() == null) continue;
                            jsonWriter.key(entry.getKey());
                            jsonWriter.value(entry.getValue());
                        }
                        jsonWriter.endObject();
                    }
                    if (eventsListValue.getMetrics() != null) {
                        jsonWriter.key("metrics");
                        jsonWriter.object();
                        for (Map.Entry<String, Object> entry : eventsListValue.getMetrics().entrySet()) {
                            if (entry.getValue() == null) continue;
                            jsonWriter.key(entry.getKey());
                            jsonWriter.value(entry.getValue());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

