/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.XpathUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3ErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log log = LogFactory.getLog(S3ErrorResponseHandler.class);

    @Override
    public AmazonServiceException handle(HttpResponse errorResponse) throws IOException {
        InputStream is = errorResponse.getContent();
        if (is == null || errorResponse.getRequest().getHttpMethod() == HttpMethodName.HEAD) {
            String requestId = errorResponse.getHeaders().get("x-amz-request-id");
            String extendedRequestId = errorResponse.getHeaders().get("x-amz-id-2");
            AmazonS3Exception ase = new AmazonS3Exception(errorResponse.getStatusText());
            int statusCode = errorResponse.getStatusCode();
            ase.setStatusCode(statusCode);
            ase.setRequestId(requestId);
            ase.setExtendedRequestId(extendedRequestId);
            ase.setErrorType(this.errorTypeOf(statusCode));
            return ase;
        }
        String content = "";
        try {
            content = IOUtils.toString(is);
        }
        catch (IOException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed in reading the error response", (Throwable)ex);
            }
            return this.newAmazonS3Exception(errorResponse.getStatusText(), errorResponse);
        }
        try {
            Document document = XpathUtils.documentFrom(content);
            String message = XpathUtils.asString("Error/Message", document);
            String errorCode = XpathUtils.asString("Error/Code", document);
            String requestId = XpathUtils.asString("Error/RequestId", document);
            String extendedRequestId = XpathUtils.asString("Error/HostId", document);
            AmazonS3Exception ase = new AmazonS3Exception(message);
            int statusCode = errorResponse.getStatusCode();
            ase.setStatusCode(statusCode);
            ase.setErrorType(this.errorTypeOf(statusCode));
            ase.setErrorCode(errorCode);
            ase.setRequestId(requestId);
            ase.setExtendedRequestId(extendedRequestId);
            return ase;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed in parsing the response as XML: " + content), (Throwable)ex);
            }
            return this.newAmazonS3Exception(content, errorResponse);
        }
    }

    private AmazonS3Exception newAmazonS3Exception(String errmsg, HttpResponse httpResponse) {
        AmazonS3Exception ase = new AmazonS3Exception(errmsg);
        int statusCode = httpResponse.getStatusCode();
        ase.setErrorCode(statusCode + " " + httpResponse.getStatusText());
        ase.setStatusCode(statusCode);
        ase.setErrorType(this.errorTypeOf(statusCode));
        return ase;
    }

    private AmazonServiceException.ErrorType errorTypeOf(int statusCode) {
        return statusCode >= 500 ? AmazonServiceException.ErrorType.Service : AmazonServiceException.ErrorType.Client;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

