/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class S3ObjectWrapper
implements Closeable {
    private final S3Object s3obj;

    S3ObjectWrapper(S3Object s3obj) {
        if (s3obj == null) {
            throw new IllegalArgumentException();
        }
        this.s3obj = s3obj;
    }

    ObjectMetadata getObjectMetadata() {
        return this.s3obj.getObjectMetadata();
    }

    void setObjectMetadata(ObjectMetadata metadata) {
        this.s3obj.setObjectMetadata(metadata);
    }

    S3ObjectInputStream getObjectContent() {
        return this.s3obj.getObjectContent();
    }

    void setObjectContent(S3ObjectInputStream objectContent) {
        this.s3obj.setObjectContent(objectContent);
    }

    void setObjectContent(InputStream objectContent) {
        this.s3obj.setObjectContent(objectContent);
    }

    String getBucketName() {
        return this.s3obj.getBucketName();
    }

    void setBucketName(String bucketName) {
        this.s3obj.setBucketName(bucketName);
    }

    String getKey() {
        return this.s3obj.getKey();
    }

    void setKey(String key) {
        this.s3obj.setKey(key);
    }

    String getRedirectLocation() {
        return this.s3obj.getRedirectLocation();
    }

    void setRedirectLocation(String redirectLocation) {
        this.s3obj.setRedirectLocation(redirectLocation);
    }

    public String toString() {
        return this.s3obj.toString();
    }

    final boolean isInstructionFile() {
        ObjectMetadata metadata = this.s3obj.getObjectMetadata();
        Map<String, String> userMeta = metadata.getUserMetadata();
        return userMeta != null && userMeta.containsKey("x-amz-crypto-instr-file");
    }

    final boolean hasEncryptionInfo() {
        ObjectMetadata metadata = this.s3obj.getObjectMetadata();
        Map<String, String> userMeta = metadata.getUserMetadata();
        return userMeta != null && userMeta.containsKey("x-amz-iv") && (userMeta.containsKey("x-amz-key-v2") || userMeta.containsKey("x-amz-key"));
    }

    String toJsonString() {
        try {
            return S3ObjectWrapper.from(this.s3obj.getObjectContent());
        }
        catch (Exception e) {
            throw new AmazonClientException("Error parsing JSON: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String from(InputStream is) throws IOException {
        if (is == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            is.close();
            throw throwable;
        }
        is.close();
        return stringBuilder.toString();
    }

    @Override
    public void close() throws IOException {
        this.s3obj.close();
    }

    S3Object getS3Object() {
        return this.s3obj;
    }

    ContentCryptoScheme encryptionSchemeOf(Map<String, String> instructionFile) {
        if (instructionFile != null) {
            String cekAlgo = instructionFile.get("x-amz-cek-alg");
            return ContentCryptoScheme.fromCEKAlgo(cekAlgo);
        }
        ObjectMetadata meta = this.s3obj.getObjectMetadata();
        Map<String, String> userMeta = meta.getUserMetadata();
        String cekAlgo = userMeta.get("x-amz-cek-alg");
        return ContentCryptoScheme.fromCEKAlgo(cekAlgo);
    }
}

